<?php
/**
 * Visforms create control HTML class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Control;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Layout\LayoutHelper;

class Uikit3RadioControl extends Control
{
	public function getControlHtml() {
        $field = $this->field->getField();
        $field->clabel = $this->createlabel();
        $field->ccustomtext = $this->getCustomText();
        $field->ctrlGroupUikit3Classes = $this->getCtClasses();
		return LayoutHelper::render('visforms.uikit3.radio.control', array('field' => $field), null, array('component' => 'com_visforms'));
	}

	public function createLabel() {
		$field = $this->field->getField();
		$labelClass = $this->getLabelClass();
		$field->labelClass = $labelClass;
		return LayoutHelper::render('visforms.uikit3.radio.label', array('field' => $field), null, array('component' => 'com_visforms'));
	}
}