<?php
/**
 * Visforms HTML class for fields
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Create HTML of a form field according to it's type
 *
 * @package        Joomla.Site
 * @subpackage    com_visforms
 * @since        1.6
 */
abstract class BaseHtmlField implements HtmlFieldInterface
{
    protected $field;
    protected $type;
	protected $decorable;
	protected $attribute_type;
	protected $isMutable = true;
	protected $decorateWithErrorDiv = true;

	public function __construct($field, $decorable, $attribute_type) {
		$this->type = $field->typefield;
		$this->field = $field;
		$this->field->isMutable = $this->isMutable;
		$this->field->decorateWithErrorDiv = $this->decorateWithErrorDiv;
        $this->setDataReadonlyOnNonMutableFields();
        $this->setDecorable($decorable);
        $this->setAttributeType($attribute_type);
        $this->setAttributePlaceholder();
	}

	abstract public function getFieldAttributeArray();

	public function setFieldValidateArray($field) {
		$validateArray = array();
		// validation rules are stored in xml-definition-fields with name that ends on _validate_rulename (i.e. _validate_minlength).
		// each form field is represented by a fieldset in xml-definition file
        // field type specific validation rules are added in the field class in setFieldCustomValidateArray
		foreach ($field as $name => $value) {
			if (!is_array($value)) {
				if (str_contains($name, 'validate')) {
					if ($value) {
						$newname = str_replace('validate_', "", $name);
						$validateArray[$newname] = $value;
					}
				}
				// user can use custom regex for custom field validation
				if (str_contains($name, 'customvalidation')) {
					if ($value) {
						$validateArray['customvalidation'] = "/" . $value . "/";
					}
				}
			}
		}
		if (count($validateArray) > 0) {
			$field->validateArray = $validateArray;
		}
		return $field;
	}

	public function getFieldType() {
		return $this->type;
	}

	public function getField() {
		return $this->field;
	}

	public function getErrorId($field) {
		return 'field' . $field->id;
	}

	public function setDecorable($state) {
		if (is_null($state)) {
			if (!(isset($this->decorable))) {
				$this->decorable = true;
			}
		} 
		else {
			$this->decorable = $state;
		}
	}

	public function getDecorable() {
		return $this->decorable;
	}

	protected function setAttributeType($type) {
		if (!is_null($type)) {
			$this->field->attribute_type = $type;
		}
	}

	protected function setAttributePlaceholder() {
        if (isset($this->field->attribute_placeholder)) {
            if ($this->field->attribute_placeholder != "") {
                $this->field->attribute_placeholder = htmlspecialchars($this->field->attribute_placeholder, ENT_COMPAT, 'UTF-8');
            }
        }
            // show label is set to hide
		if (!empty($this->field->show_label)) {
            // no placeholder available for field
            if (empty($this->field->attribute_placeholder)) {
                // set label text into placeholder
                if (isset($this->field->label)) {
                    $this->field->attribute_placeholder = htmlspecialchars($this->field->label . ((isset($this->field->attribute_required) && !empty($this->field->showRequiredAsterix)) ? ' *' : ''), ENT_COMPAT, 'UTF-8');
                }
            }
        }
	}

	// In database we store readonly property always as 'attribute_readonly',
    // in order to be able to manage the property in the administration equally regardless of field type
    // In Form view, we need to treat readonly like behaviour differently, depending on field type
    // Replace attribute_readonly with attribute_data-readonly
    // Do it as early as possible
	protected function setDataReadonlyOnNonMutableFields() {
	    if (!$this->field->isMutable) {
	        if (isset($this->field->attribute_readonly)) {
                $this->field->{'attribute_data-readonly'} = "1";
                $this->field->{'attribute_aria-readonly'} = "true";
                $this->field->noFocus = true;
                // The role attribute is only necessary on un-mutable pseudo-readonly fields
                $this->setRoleAttribute();
	            unset($this->field->attribute_readonly);
            }
        }
    }

    protected function setRoleAttribute() {}

}