<?php
/**
 * Visforms HTML class for pagebreack button
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

class PagebreakField extends BaseHtmlField
{
    protected $isMutable = false;

	public function __construct($field, $decorable, $attribute_type) {
		if (is_null($decorable)) {
			$decorable = false;
		}
		if (is_null($attribute_type)) {
			$attribute_type = "button";
		}
		parent::__construct($field, $decorable, $attribute_type);
	}

    // create an array of HTML attributes for the HTML control
	public function getFieldAttributeArray() {
		$attributeArray = array('class' => '');
        // HTML attributes are stored in xml-definition-fields with name that ends on _attribute_attributename (i.e. _attribute_checked)
        // names from xml field definition are used, to create the HTML attributes for the control
        // in the xml-definition file each form field is represented by a fieldset
        // in the xml-definition file each form field should have a xml-definition-field with a name that ends on _attribute_class
        // the following code converts the xml-definition-field-names to HTML attribute names and sets the values for the HTML attributes
		foreach ($this->field as $name => $value) {
			if (!is_array($value)) {
				if (str_contains($name, 'attribute_')) {
					if ($value || $name == 'attribute_class') {
						$newname = str_replace('attribute_', "", $name);
						if ($newname == "class") {
                            $value = $value . (!empty($value) ? ' ' : '') . $this->field->fieldCSSclass;
							$attributeArray[$newname] .= $value;
						}
						else {
							$attributeArray[$newname] = $value;
						}
					}
				}
				if ($name == 'name') {
					$attributeArray['name'] = $value;
				}
				if ($name == 'id') {
					$value = 'field' . $value;
					$attributeArray['id'] = $value;
				}
				// specific settings for buttons
				$attributeArray['aria-label'] = $this->field->label;
				$attributeArray['value'] = $this->field->label;
			}
		}
		return $attributeArray;
	}
    // bootstrap 5
    public function setControlBt5HtmlClasses($field) {
        $field->attribute_class = (!empty($this->field->fieldCSSclass)) ? ' btn next_btn' : ' btn next_btn btn-info';
        return $field;
    }

	// uikit 3
	public function setUikit3ControlHtmlClasses($field) {
		$field->attribute_class = (!empty($this->field->fieldCSSclass)) ? ' btn next_btn' : ' btn next_btn uk-button-default';
		return $field;
	}
}