<?php
/**
 * Visforms HTML class for textarea fields
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

class TextareaField extends BaseHtmlField
{
	public function __construct($field, $decorable, $attribute_type) {
		//prevent email-cloaking in form displayed in content, when a default value is set
		if (isset ($field->initvalue) && ($field->initvalue != "")) {
			$field->initvalue = str_replace('@', '&#64', $field->initvalue);
		}
		parent::__construct($field, $decorable, $attribute_type);
	}

    // create an array of HTML attributes for the HTML control
	public function getFieldAttributeArray() {
		$attributeArray = array('class' => '');
        // HTML attributes are stored in xml-definition-fields with name that ends on _attribute_attributename (i.e. _attribute_checked)
        // names from xml field definition are used, to create the HTML attributes for the control
        // in the xml-definition file each form field is represented by a fieldset
        // in the xml-definition file each form field should have a xml-definition-field with a name that ends on _attribute_class
        // the following code converts the xml-definition-field-names to HTML attribute names and sets the values for the HTML attributes
		foreach ($this->field as $name => $value) {
			if (!is_array($value)) {
				if (str_contains($name, 'attribute_')) {
					if ($name == 'attribute_required') {
						$attributeArray['aria-required'] = 'true';
					}
					if ($value || $name == 'attribute_class') {
						$newname = str_replace('attribute_', "", $name);
						if ($newname == "class") {
							$value = $value . (!empty($value) ? ' ' : '') . $this->field->fieldCSSclass;
							if ((isset($this->field->textareaRequired) && $this->field->textareaRequired === true) || (isset($this->field->hasHTMLEditor) && $this->field->hasHTMLEditor == true)) {
								$value = " visforms-editor-tinymce";
							}
							$attributeArray[$newname] .= $value;
						}
                        else if ($newname == 'placeholder' && !empty($value)) {
                            $attributeArray[$newname] = str_replace('@', '&#64', $value);
                        }
						else {
							$attributeArray[$newname] = $value;
						}
					}
				}
				if ($name == 'name') {
					$attributeArray['name'] = $value;
				}
				if ($name == 'id') {
					$value = 'field' . $value;
					$attributeArray['id'] = $value;
					$attributeArray['data-error-container-id'] = 'fc-tbx' . $value;
				}
				if (($name == 'isDisabled') && ($value == true)) {
					$attributeArray['class'] .= " ignore";
					$attributeArray['disabled'] = "disabled";
				}
				if (($name == 'isDisplayChanger') && ($value == true)) {
					$attributeArray['class'] .= " displayChanger";
				}
				if (($name == 'isValid') && ($value == false)) {
					$attributeArray['class'] .= " error";
				}
				if (isset($this->field->hasHTMLEditor) && $this->field->hasHTMLEditor) {
					// set some special attribute for the textarea that is linked to the editor
					$attributeArray['style'] = "width: 97%; height: 200px;";
				}
				if (!isset($attributeArray['cols']) || $attributeArray['cols'] == "") {
					$attributeArray['cols'] = "10";
				}
				if (!isset($attributeArray['rows']) || $attributeArray['rows'] == "") {
					$attributeArray['rows'] = "20";
				}
				$attributeArray['aria-labelledby'] = $this->field->name . 'lbl';
			}
		}
		return $attributeArray;
	}
    // bootstrap 5
    public function setControlBt5HtmlClasses($field) {
        $field->attribute_class = " form-control";
        return $field;
    }

	// uikit3
	public function setUikit3ControlHtmlClasses($field) {
		$field->attribute_class = " uk-textarea";
		return $field;
	}
}