<?php
/**
 * Visforms Layout class Bootstrap default
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Layout;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Visolutions\Component\Visforms\Site\Lib\Html\Control\ControlAwareTrait;
use Visolutions\Component\Visforms\Site\Lib\Html\Control\Decorator\Bt5Decorator;

class Bt5Layout extends HtmlLayout
{
    use ControlAwareTrait;

	public function prepareHtml() {
		//attach error messages array for javascript validation to field
		$this->setFieldCustomErrorMessageArray();
		$this->cleanFieldProperties();
		$this->getFieldGroupBootstrapClasses();
		$this->setControlBt5HtmlClasses();
		$this->setToolTip();
		$this->setErrorId();
		$this->setFieldAttributeArray();
		$this->setFieldValidateArray();
		$this->setFieldControlHtml();
		return $this->field;
	}

	protected function setControlBt5HtmlClasses() {
	    // Bootstrap 5 specific field class (i.e. form-select)
        if (method_exists($this->fieldHtml, 'setControlBt5HtmlClasses')) {
            $this->field = $this->fieldHtml->setControlBt5HtmlClasses($this->field);
        }
		else {
			// default implementation
			$this->field->attribute_class = " form-control ";
		}
	}

	protected function setFieldControlHtml() {
		// get Instance of field html control class according to field type and layout type
        $this->setControl($this->fieldHtml, $this->type);
        $ocontrol = $this->getControl();
		// $ocontrol = VisformsHtmlControl::getInstance($this->fieldHtml, $this->type);
		if (!(is_object($ocontrol))) {
			//throw an error
		}
		else {
			// instantiate decorators
			$control = new Bt5Decorator($ocontrol);
		}
		// set field property
		$this->field->controlHtml = $control->getControlHtml();
	}

	protected function cleanFieldProperties() {
		$breakpoints = array('Sm', 'Md', 'Lg', 'Xl', 'Xxl');
		// List of the old options, which could be selected as control group width, but which actually are fields per row
        $fieldsPerRowOptions = array(1,2,3,4,6,12);
		$this->field->attribute_class = "";
		if (!isset($this->field->show_label)) {
			$this->field->show_label = 0;
		}
        // set width value for default col class without breakpoint
        // no individual layout: Default to 1 field per row
        if ($this->subType != 'individual') {
            $this->field->fieldsPerRow = "1";
        }
        // no value set: Default to 1 field per row
        else if (empty($this->field->fieldsPerRow)) {
            $this->field->fieldsPerRow = "1";
        }
        // old fields per row value
        // convert field per rows into actual gridWidth of control group
        else if (in_array($this->field->fieldsPerRow, $fieldsPerRowOptions)) {
            $this->field->controlGroupGridWidth = (12 / $this->field->fieldsPerRow);
        }
        // use configuration value directly
        else {
            $this->field->controlGroupGridWidth = $this->field->fieldsPerRow;
        }

        if (empty($this->field->controlGroupGridWidth) || ($this->subType != 'individual')) {
            $this->field->controlGroupGridWidth = "12";
        }
		if (empty($this->field->labelBootstrapWidth) || ($this->subType != 'individual')) {
			if ($this->subType == 'stacked' || $this->subType == 'individual') {
				$this->field->labelBootstrapWidth = "12";
			}
			else {
				$this->field->labelBootstrapWidth = "3";
			}
		}
		foreach ($breakpoints as $breakpoint) {
			$fieldsPerRow = 'fieldsPerRow' . $breakpoint;
			// Bootstrap supports splitting grid into up to 12 columns
            // our old control group width configuration as fields per row only allows 6 different width options
            // vfsub 5.0.0 implements fieldGroupGridWidth instead of fiedsPerRow
            // this is a mix of the old fields per row values 1, 2, 3, 4, 6, 12 and the new additional values 5, 7, 8, 9, 10, 11
            // keep old fieldsPerRow
            $controlGroupGridWidth = 'controlGroupGridWidth' . $breakpoint;
			if (empty($this->field->$fieldsPerRow) || ($this->subType != 'individual')) {
				$this->field->$fieldsPerRow = "1";
			}
            if (empty($this->field->$controlGroupGridWidth) || ($this->subType != 'individual')) {
                $this->field->$controlGroupGridWidth = "12";
            }
			if ($this->subType == 'individual') {
			    if (in_array($this->field->$fieldsPerRow, $fieldsPerRowOptions)) {
			        // old fields per row value
                    // convert field per rows into actuall gridWidth of control group
                    $this->field->$controlGroupGridWidth = (12 / $this->field->$fieldsPerRow);
                }
                else {
                    // new grid width value
                    // just set value
                    $this->field->$controlGroupGridWidth = $this->field->$fieldsPerRow;
                }
            }
			$labelBootstrapWidth = 'labelBootstrapWidth' . $breakpoint;
			if (empty($this->field->$labelBootstrapWidth) || ($this->subType != 'individual')) {
				if ($this->subType == 'stacked' || $this->subType == 'individual') {
					$this->field->$labelBootstrapWidth = "12";
				}
				else {
					$this->field->$labelBootstrapWidth = "3";
				}
			}

		}
		// Positions of custom text between label and input only possible in stacked layouts
        if ($this->subType === 'horizontal' && isset($this->field->customtextposition) && ($this->field->customtextposition == 1)) {
            $this->field->customtextposition = 0;
        }
        //  or in individual layouts where label width is set to 12/12 for all! breakpoints
        else if ($this->subType === 'individual' && isset($this->field->customtextposition) && ($this->field->customtextposition == 1)) {
            foreach ($breakpoints as $breakpoint) {
                $labelBootstrapWidth = 'labelBootstrapWidth' . $breakpoint;
                if ($this->field->$labelBootstrapWidth != "12") {
                    $this->field->customtextposition = 0;
                    break;
                }
            }
        }
		if (!isset($this->field->custominfo)) {
			$this->field->custominfo = "";
		}
	}

	protected function getFieldGroupBootstrapClasses() {
		$this->field->fieldGroupBootstrapClasses = 'col-' . $this->field->controlGroupGridWidth;
		if ($this->field->controlGroupGridWidthSm != "12") {
			$this->field->fieldGroupBootstrapClasses .= ' col-sm-' . $this->field->controlGroupGridWidthSm;
		}
		if ($this->field->controlGroupGridWidthMd != "12") {
			$this->field->fieldGroupBootstrapClasses .= ' col-md-' . $this->field->controlGroupGridWidthMd;
		}
		if ($this->field->controlGroupGridWidthLg != "12") {
			$this->field->fieldGroupBootstrapClasses .= ' col-lg-' . $this->field->controlGroupGridWidthLg;
		}
		if ($this->field->controlGroupGridWidthXl != "12") {
			$this->field->fieldGroupBootstrapClasses .= ' col-xl-' . $this->field->controlGroupGridWidthXl;
		}
        if ($this->field->controlGroupGridWidthXxl != "12") {
            $this->field->fieldGroupBootstrapClasses .= ' col-xxl-' . $this->field->controlGroupGridWidthXxl;
        }
		if (isset($this->field->controlGroupCSSclass)) {
			$this->field->fieldGroupBootstrapClasses .= ' ' . trim($this->field->controlGroupCSSclass);
		}
	}
}