<?php
/**
 * Visforms HTMLLayout class 
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Layout;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\HTML\HTMLHelper;
use Visolutions\Component\Visforms\Administrator\Service\HTML\Visforms;
use Visolutions\Component\Visforms\Site\Lib\Html\Field\BaseHtmlField;
use Visolutions\Component\Visforms\Site\Lib\Html\Control\ControlAwareTrait;

abstract class HtmlLayout implements HtmlLayoutInterface
{
    use ControlAwareTrait;
	protected $type;
	protected $fieldHtml;
	protected $field;
	protected $fieldtype;
	protected $subType;
	protected $control;

	public function __construct($type, BaseHtmlField $fieldHtml, $subType) {
		$this->type = $type;
		$this->fieldHtml = $fieldHtml;
		$this->field = $fieldHtml->getField();
		$this->fieldtype = $fieldHtml->getFieldType();
		$this->subType = $subType;
		$this->setControl($this->fieldHtml, $this->type);
		$this->control = $this->getControl();// VisformsHtmlControl::getInstance($this->fieldHtml, $this->type);
	}

	abstract public function prepareHtml();

	abstract protected function setFieldControlHtml();

	protected function setFieldValidateArray() {
		$this->field = $this->fieldHtml->setFieldValidateArray($this->field);
		// only a view field types (at the moment the date type) have individual Validations, attach those rules
		if (method_exists($this->fieldHtml, 'setFieldCustomValidateArray')) {
			$this->field = $this->fieldHtml->setFieldCustomValidateArray($this->field);
		}
	}

	protected function removeUnsupportedShowLabel() {
		if (method_exists($this->fieldHtml, 'removeUnsupportedShowLabel')) {
			$this->field = $this->fieldHtml->removeUnsupportedShowLabel($this->field);
		}
	}

	protected function setFieldCustomErrorMessageArray() {
	    // validation rules come from different sources
        // xml-definition-fields with name that ends on validate_rulename (i.e. validate_minlength)
        // HTML attributes set in field configuration option with attribute_ (i.e. attribute_maxlength)
        // Type attribute of HTML input, set in field configuration option typefield (i.e. email)
        // Custom validation options, set in field configuration option with specific names (customvalidation)
        // These lists are maintained in the Visforms Helper Class
        // If a Custom Error Message is set in field configuration, replace the default error message of each validation with the custom error message
		if (isset($this->field->customerror) && $this->field->customerror != "") {
		    // replace all occurrences of @ in custom error messages , because Joomla email cloaking will break javascript
           $this->field->customerror = str_replace(array('@'), array('&#64'), $this->field->customerror);
			foreach ($this->field as $name => $value) {
				if (!is_array($value)) {
					if ($value) {
                        // field option starts with validate_
                        if (str_contains($name, 'validate')) {
                            $name = str_replace('validate_', "", $name);
                            $this->field->customErrorMsgArray[$name] = $this->field->customerror;
                        }
					    // field option with a custom name
                        if (in_array($name, Visforms::customValidationNames)) {
                            $this->field->customErrorMsgArray[$name] = $this->field->customerror;
                        }
						// field option starts with attribute
						if (str_contains($name, 'attribute_')) {
							$name = str_replace('attribute_', "", $name);
							if (in_array($name, Visforms::htmlValidationAttribs)) {
								$this->field->customErrorMsgArray[$name] = $this->field->customerror;
							}
						}
						// field type specific validation
						$name = $this->field->typefield;
						if (in_array($name, Visforms::htmlValidatonInputTypes)) {
							$this->field->customErrorMsgArray[$name] = $this->field->customerror;
						}
					}
				}
			}
		}
	}

	protected function setErrorId() {
		$this->field->errorId = $this->fieldHtml->getErrorId($this->field);
	}

	protected function setFieldAttributeArray() {
		$this->field->attributeArray = $this->fieldHtml->getFieldAttributeArray();
	}

	protected function makeFieldUneditable() {
	    // edit view: fields cannot be edited due to missing permission
        // the following code handles readonly properly for all field types, even non-mutable one's
		if (isset($this->field->isForbidden) && ($this->field->isForbidden == true)) {
            // no double muting if non-mutable field has both, option readonly and isForbidden by user permissions
            // data_readonly will be re-added once in non-mutable field's custom makeFieldUneditable function
            if (isset($this->field->{'attribute_data-readonly'})) {
                unset($this->field->{'attribute_data-readonly'});
            }
            // a view field types need custom care
            if (method_exists($this->fieldHtml, 'makeFieldUneditable')) {
                $this->field = $this->fieldHtml->makeFieldUneditable($this->field);
            }
            else {
                // set a readonly attribute
                $this->field->attribute_readonly = 'readonly';
            }
        }
    }

    protected function setToolTip() {
	    // override when a non bootstrap tooltip is necessary, i.e. uikit layouts
        // add Attributes necessary to display a bootstrap tootip
        if (method_exists($this->fieldHtml, 'setToolTip')) {
            $this->field = $this->fieldHtml->setToolTip($this->field);
        }
        else {
            if (!empty($this->field->custominfo)) {
                $this->field->attribute_title = htmlspecialchars($this->field->custominfo, ENT_COMPAT, 'UTF-8');
                $this->field->attribute_class .= ' visToolTip';
                $this->field->{'attribute_data-bs-toggle'} = 'tooltip';
                HTMLHelper::_('visforms.visformsTooltip');
            }
        }
    }
}