<?php
/**
 * Visforms Layout class Bootstrap default
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Layout;

// no direct access
defined('_JEXEC') or die('Restricted access');

class Bt5EditLayout extends BaseLayout
{
	protected function getCustomRequiredCss() {
		$fullParent = 'form#' . $this->parentFormId;
		$css = array();
		// css for required fields
		$css[] = $fullParent . ' div.required .asterix-ancor:after ';
		$css[] = '{content:"*"; color:'.$this->requiredAsteriskColor.'; display: inline-block; padding-left: 10px;} ';
        $css[] = $fullParent . ' .vis_mandatory';
        $css[] = '{color:'.$this->requiredTextColor.';} ';
		return implode('', $css);
	}

	protected function addCustomCss() {
		$fullParent = 'form#' . $this->parentFormId;
		$css        = array();
		// add some space between summary page and buttons on multi page layouts
		$css[] = $fullParent . ' #' . $this->parentFormId .'_summarypage {margin-bottom: 15px;}';
		return implode('', $css);
	}

    protected function addDefaultResponsiveCss() {
        return '';
    }
}