<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2019 vi-solutions
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Layout\Helper;
// no direct access
defined('_JEXEC') or die('Restricted access');

class FormLayoutHelper {
	private $form = null;
	private $formLayoutState = null;

	public function __construct($form) {
		$this->form = $form;
		$className = $this->getLayoutClassName();
		$this->setFormLayoutState(new $className());
	}

	public function getForm() {
		return $this->form;
	}

	public function updateForm($form) {
		$this->form = $form;
	}

	public function fixInvalidLayoutSelection () {
		return $this->formLayoutState->fixInvalidLayoutSelection($this);
	}

	public function setLayoutOptions() {
		return $this->formLayoutState->setLayoutOptions($this);
	}

	public function setFormLayoutState($layoutState) {
		$this->formLayoutState = $layoutState;
	}

    private function getLayoutClassName() {
        $name = $this->form->formlayout;
        switch ($name) {
            case 'bt5' :
            case 'editbt5' :
                $className = 'Bt5FormLayoutStateHelper';
                break;
            case 'uikit3' :
            case 'edidtuikit3' :
                $className = 'Uikit3FormLayoutStateHelper';
                break;
            default :
                $className = 'NoneFormLayoutStateHelper';
        }
        return '\Visolutions\Component\Visforms\Site\Lib\Layout\Helper\\'.$className;
    }
}