<?php
/**
 * Visforms Layout class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Layout;
// no direct access
defined('_JEXEC') or die('Restricted access');

trait LayoutAwareTrait
{
    private $formLayout = null;

    public function setFormLayout($form) {
        $type = $form->formlayout;
        $className = $this->getLayoutClassName($type);
        $this->formLayout = new $className($form);
    }

    public function getFormLayout() {
        if ($this->formLayout) {
            return $this->formLayout;
        }
        throw new \UnexpectedValueException('FormLayout not set in ' . __CLASS__);
    }

    private function getLayoutClassName($name) {
        switch ($name) {
            case 'bt5' :
                $className = 'Bt5Layout';
                break;
            case 'editbt5' :
                $className = 'Bt5EditLayout';
                break;
            case 'uikit3' :
                $className = 'Uikit3Layout';
                break;
            case 'edituikit3' :
                $className = 'Uikit3EditLayout';
                break;
            case 'edit' :
                $className = 'NoneEditLayout';
                break;
            default :
                $className = 'NoneLayout';
        }
        return '\Visolutions\Component\Visforms\Site\Lib\Layout\\'.$className;
    }
}