<?php
/**
 * Visforms message email class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Message;

// no direct access
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Language\Text;

class MinMessage extends DefaultMessage
{
    protected $text = 'COM_VISFORMS_FIELD_MIN_VALUE';

    protected function setMessage(): string {
        // if we have a custom php error message, return ''
        // the custom php error message is added in the business/field class only once to each invalid field
        if (!empty($this->customText)) {
            return '';
        }
        else {
            $min = (isset($this->args['min'])) ? $this->args['min'] : '';
            return Text::sprintf($this->text, $this->name, $min);
        }
    }
}