<?php
/**
 * Visforms validate email class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace Visolutions\Component\Visforms\Site\Lib\Validation;

// no direct access
defined('_JEXEC') or die('Restricted access');

class EmailValidation extends Validation
{
	protected $value;
	protected $regex;

	public function __construct($args) {
	    parent::__construct($args);
		$this->regex = '/^([a-zA-Z0-9_\.\-\+%])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/';
		// ToDo Joomla uses the following Regex for email format validation; Do we want to adapt for J6?
        // $this->regex = "^[a-zA-Z0-9.!#$%&'*+\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])"
        //                . "?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$";

        // we expect an item with key 'value' in $args
		$this->value = $this->args['value'] ?? "";
	}

    public function validate(): bool {
		if (!(preg_match($this->regex, $this->value))) {
			return false;
		} 
		else {
			return true;
		}
	}
}