<?php
/**
 * Visforms validate min class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace Visolutions\Component\Visforms\Site\Lib\Validation;

// no direct access
defined('_JEXEC') or die('Restricted access');

class MinNumberValidation extends Validation
{
	protected $count;
	protected $minCount;

	public function __construct($args) {
        parent::__construct($args);
		// we expect an item with key 'count' and an item with key 'mincount' in $args
		$this->count = $this->args['count'] ?? 0;
		$this->minCount = $this->args['mincount'] ?? 0;
	}

    public function validate(): bool {
		if ($this->count < $this->minCount) {
			return false;

		} 
		else {
			return true;
		}
	}
}