<?php
/**
 * Visforms validate date class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace Visolutions\Component\Visforms\Site\Lib\Validation;

// no direct access
defined('_JEXEC') or die('Restricted access');

class PhoneValidation extends Validation
{
	protected $value;
	protected $format;
	protected $regexArray = [
        'NANP'  => '/^(?:\+?1[-. ]?)?\(?([2-9][0-8][0-9])\)?[-. ]?([2-9][0-9]{2})[-. ]?([0-9]{4})$/',
        'ITU-T' => '/^\+(?:[0-9] ?){6,14}[0-9]$/',
        'EPP'   => '/^\+[0-9]{1,3}\.[0-9]{4,14}(?:x.+)?$/',
        'GERMANY' => '/^((\+[1-9]{1}\d{1,4}) ?|0)[1-9]{1}\d{1,3} ?[1-9]{1}\d{3,12}(-\d+)?$/',
        'NATIONAL'=> '/^\d+$/'
    ];

	public function __construct($args) {
        parent::__construct($args);
		// we expect a key 'value' and a key 'format' in $args
		$this->value = $this->args['value'] ?? "";
		$this->format = $this->args['format'] ?? "";
	}

    public function validate(): bool {
        if (!array_key_exists($this->format, $this->regexArray)) {
            return true;
        }
        $regex = $this->regexArray[$this->format];

        if (!(preg_match($regex, $this->value))) {
            return false;
        }
        else {
            return true;
        }
	}
}