<?php
/**
 * Visforms Mail Helper class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 5.3
 */

namespace Visolutions\Component\Visforms\Site\Model\Helper\Mail;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Log\Log;
use Joomla\CMS\Mail\MailerFactoryInterface;
use Joomla\Filesystem\File;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Language\Text;
use Visolutions\Component\Visforms\Administrator\Helper\AefHelper;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsBeforeEmailPrepareEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsEmailPrepareEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsPrepareDoiMailTextEvent;
use Visolutions\Component\Visforms\Site\Log\VisformsLogTrait;
use Visolutions\Component\Visforms\Site\Model\VisformsModel;
use Visolutions\Component\Visforms\Administrator\Model\Helper\DeleteIfEmpty;
use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper;
use Visolutions\Component\Visforms\Site\Lib\Validation\EmailValidation;

require_once JPATH_LIBRARIES . '/visolutions/simple_html_dom/simple_html_dom.php';

class BaseMailHelper
{
    use VisformsLogTrait;
    protected $form;
    // visforms or edit
    protected $model;
    protected $view;
    protected $type;
    protected $dataHelper;
    protected $mailer;

    public function __construct( VisformsModel $model, $form) {
        // $this->view = $view;
        $this->form = $form;
        $this->model = $model;
        $this->view = $model->getName();
        $this->initializeLogger('visformssubmit');
        $this->mailer = Factory::getContainer()->get(MailerFactoryInterface::class);
    }

    public function sendAdminMail () {
        $this->type = 'admin';
        $visform = $this->form;
        $model = $this->model;
        if (!$this->setDataHelper()) {
            return false;
        }
        PluginHelper::importPlugin('visforms');
        $beforeEmailPrepareEvent = new VisformsBeforeEmailPrepareEvent('onVisformsBeforeEmailPrepare', [
            'subject' => $visform,
            'context' => 'com_visforms.form.resultmail',
        ]);
        $model->getDispatcher()->dispatch('onVisformsBeforeEmailPrepare', $beforeEmailPrepareEvent);
        $emailSender = "";
        // get reply to mail
        $n = count($visform->fields);
        for ($i = 0; $i < $n; $i++) {
            $field = $visform->fields[$i];
            if ($field->typefield == 'email') {
                if (($field->dbValue)) {
                    $emailSender = $field->dbValue;
                    break;
                }
            }
        }
        $mailBody = '';
        if ((!empty($visform->emailresulttext))) {
            $replacedText = $this->deleteIfEmpty($model->replacePlaceholder($visform, $visform->emailresulttext));
            $mailBody .= HTMLHelper::_('visforms.fixLinksInMail', $replacedText);
        }
        $bodyData = array();
        if ((!isset($visform->emailresultincformtitle)) || (isset($visform->emailresultincformtitle) && $visform->emailresultincformtitle == 1)) {
            $bodyData[] = Text::_('COM_VISFORMS_FORM') . " : " . $visform->title;
        }
        if ((!isset($visform->emailresultinccreated)) || (isset($visform->emailresultinccreated) && $visform->emailresultinccreated == 1)) {
            $bodyData[] = Text::_('COM_VISFORMS_REGISTERED_AT') . " " . VisformsHelper::getFormattedServerDateTime('now');
        }
        // Include user inputs if parameter is set to true
        if ($visform->emailresultincfield == 1) {
            $bodyData[] = $this->dataHelper->getMailIncludeData($visform, 'result');
        }
        if ((!(empty($visform->dataRecordId))) && isset($visform->emailresultincdatarecordid) && ($visform->emailresultincdatarecordid == 1)) {
            $bodyData[] = Text::_('COM_VISFORMS_RECORD_SET_ID') . " : " . $visform->dataRecordId;
        }
        if (!isset($visform->emailresultincip) || (isset($visform->emailresultincip) && ($visform->emailresultincip == 1))) {
            $bodyData[] = Text::_('COM_VISFORMS_IP_ADDRESS') . " : " . $_SERVER['REMOTE_ADDR'];
        }
        $bodyData = implode('<br />', $bodyData);
        if (!empty($bodyData)) {
            $mailBody .= '<p>' . $bodyData . '</p>';
        }
        // Attach files to email
        try {
            $mail = $this->mailer->createMailer();
            $mail->CharSet = "utf-8";
            if (!empty($visform->emailresultincfile)) {
                for ($i = 0; $i < $n; $i++) {
                    $field = $visform->fields[$i];
                    if ($field->typefield == 'file' && isset($_FILES[$field->name]['name']) && $_FILES[$field->name]['name'] != '') {
                        if (!empty($field->file['filepath']) && !empty($field->file['name'])) {
                            $attachmentName = $field->file['name'];
                            if (!empty($field->fileattachmentname)) {
                                $attachmentName = $this->getAttachementName($field->fileattachmentname, $attachmentName);
                            }
                            $mail->addAttachment($field->file['filepath'], $attachmentName);
                        }
                    }
                    else if ($field->typefield == 'file' && ($visform->emailresultincfile == "2") && !empty($field->orgfile->filepath)) {
                        if (!empty($field->fileattachmentname)) {
                            $attachmentName = $this->getAttachementName($field->fileattachmentname, $field->orgfile->filepath);
                            $mail->addAttachment($field->orgfile->filepath, $attachmentName);
                        }
                        else {
                            $mail->addAttachment($field->orgfile->filepath);
                        }
                    }
                }
            }

            if (trim($visform->emailto) !== '') {
                $replacedMailTos = $this->replacePlaceholderInMailAdressParameter('emailto');
                if (!empty($replacedMailTos)) {
                    $mail->addRecipient($replacedMailTos);
                }
            }
            if (trim($visform->emailcc) !== '') {
                $replacedMailCcs = $this->replacePlaceholderInMailAdressParameter('emailcc');
                if (!empty($replacedMailCcs)) {
                    $mail->addCC($replacedMailCcs);
                }
            }
            if (trim($visform->emailbcc) !== '') {
                $replacedMailBccs = $this->replacePlaceholderInMailAdressParameter('emailbcc');
                if (!empty($replacedMailBccs)) {
                    $mail->addBCC($replacedMailBccs);
                }
            }
            // there can always only be one mail from!
            if (!empty($visform->emailfrom)) {
                $replacedMailFromAddress = $model->replacePlaceholder($visform, trim($visform->emailfrom), array('email', 'text', 'hidden'), true);
                $replacedEMailFromName = $model->replacePlaceholder($visform, trim($visform->emailfromname), array('email', 'text', 'hidden'));
                $mail->setSender(array(((!empty($replacedMailFromAddress)) ? $replacedMailFromAddress : $visform->emailfrom), $replacedEMailFromName));
            }
            $subject = $model->replacePlaceholder($visform, $visform->subject);
            $mail->setSubject($subject);
            if ($emailSender != "") {
                $mail->addReplyTo($emailSender);
            }
            $mail->IsHTML(true);
            $mail->Encoding = 'base64';
            $mail->setBody($mailBody);
            $emailPrepareEvent = new VisformsEmailPrepareEvent('onVisformsEmailPrepare', [
                'subject' => $mail,
                'context' => 'com_visforms.form.resultmail',
                'form' => $visform,
            ]);
            $model->getDispatcher()->dispatch('onVisformsEmailPrepare', $emailPrepareEvent);
            $mailRecipientAdresses = $mail->getAllRecipientAddresses();
            if (empty($mailRecipientAdresses)) {
                if (!empty($visform->emailresultloggingtype)) {
                    // Log
                    $this->addLogEntry(Text::sprintf('COM_VISFORMS_LOG_MAIL_FAILURE', Text::_('COM_VISFORMS_RESULT_MAIL'), $visform->id, Text::_('COM_VISFORMS_MAIL_FAILURE_NO_RECIPIENT_MAIL_ADDRESSES_PROVIDED')) , Log::WARNING);
                }
                // no mail to addresses set
                // this might be intentional
                return true;
            }
            $mail->Send();
            // add success logging
            // one entry for each mail address
            if (!empty($visform->emailresultloggingtype)) {
                foreach ($mailRecipientAdresses as $adress => $success) {
                    $this->addLogEntry(Text::sprintf('COM_VISFORMS_LOG_MAIL_SUCCESS', Text::_('COM_VISFORMS_RESULT_MAIL'), $visform->id, $adress) , Log::INFO);
                }
            }
            return true;
        }
        catch (\Exception $e) {
            // log errors to inspector
            if (empty($visform->saveresult)) {
                // form data are not stored in the database and admin email failed. So data are completely lost
                $this->addLogEntry(Text::sprintf('COM_VISFORMS_LOG_MAIL_FAILURE', Text::_('COM_VISFORMS_RESULT_MAIL'), $visform->id, $e->getMessage()), Log::ERROR);
                return false;
            }
            else {
                // form data are stored successfully in the database but admin email failed
                $this->addLogEntry(Text::sprintf('COM_VISFORMS_LOG_MAIL_FAILURE', Text::_('COM_VISFORMS_RESULT_MAIL'), $visform->id, $e->getMessage()), Log::WARNING);
                return true;
            }
        }
    }

    public function sendUserMail () {
        $this->type = 'user';
        $visform = $this->form;
        $model = $this->model;
        if (!$this->setDataHelper()) {
            return false;
        }
        // we can only send a mail, if the form has a field of type email, that contains an email
        $isSendMail = false;
        $emailReceiptTo = '';
        $mailBody = '';
        $n = count($visform->fields);
        $formHasEmailField = false;
        // Do we have an e-mail field with value? Then get to mail address to which to send the mail to
        for ($i = 0; $i < $n; $i++) {
            $field = $visform->fields[$i];
            if ($field->typefield == 'email') {
                $formHasEmailField = true;
                if ($field->dbValue) {
                    $isSendMail = true;
                    $emailReceiptTo = $field->dbValue;
                    break;
                }
            }
        }
        if (empty($isSendMail) || empty($emailReceiptTo)) {
            if (!empty($visform->emailreceiptloggingtype)) {
                // Log
                if (!$formHasEmailField) {
                    $this->addLogEntry(Text::sprintf('COM_VISFORMS_LOG_MAIL_FAILURE', Text::_('COM_VISFORMS_RECEIPT_MAIL'), $visform->id, Text::_('COM_VISFORMS_MAIL_FAILURE_NO_EMAIL_FIELD')), Log::WARNING);
                }
                else {
                    $this->addLogEntry(Text::sprintf('COM_VISFORMS_LOG_MAIL_FAILURE', Text::_('COM_VISFORMS_RECEIPT_MAIL'), $visform->id, Text::_('COM_VISFORMS_MAIL_FAILURE_NO_RECIPIENT_MAIL_ADDRESSES_PROVIDED')), Log::WARNING);
                }
            }
            // Add log entry no email field not given in form or empty depending on $formHasEmailField
            return true;
        }
        PluginHelper::importPlugin('visforms');
        $app = Factory::getApplication();
        if (!empty($visform->emailreceipttext)) {
            // Do some replacements in email text
            $text = $visform->emailreceipttext;
            // allow plugins to modify the user email text
            $prepareDoiMailTextEvent = new VisformsPrepareDoiMailTextEvent('onVisformsPrepareDoiMailText', [
                'subject' => $visform,
                'context' => 'com_visforms.form.receiptmail',
                'text' => $text,

            ]);
            $text = $model->getDispatcher()->dispatch('onVisformsPrepareDoiMailText', $prepareDoiMailTextEvent)->getArgument('text', $text);
            $visform->emailreceipttext = $text;
        }
        $beforeEmailPrepareEvent = new VisformsBeforeEmailPrepareEvent('onVisformsBeforeEmailPrepare', [
            'subject' => $visform,
            'context' => 'com_visforms.form.receiptmail',
        ]);
        $model->getDispatcher()->dispatch('onVisformsBeforeEmailPrepare', $beforeEmailPrepareEvent);
        if (!empty($visform->emailreceipttext)) {
            // Do some replacements in email text
            $replacedText = $this->deleteIfEmpty($model->replacePlaceholder($visform, $visform->emailreceipttext));
            $mailBody .= HTMLHelper::_('visforms.fixLinksInMail', $replacedText);
        }
        $bodyData = array();
        if ($visform->emailreceiptincformtitle == 1) {
            $bodyData[] = Text::_('COM_VISFORMS_FORM') . " : " . $visform->title;
        }
        if ($visform->emailreceiptinccreated == 1) {
            $bodyData[] = Text::_('COM_VISFORMS_REGISTERED_AT') . " " . VisformsHelper::getFormattedServerDateTime('now');
        }

        // Include user inputs if parameter is set to true
        if ($visform->emailreceiptincfield == 1) {
            $bodyData[] = $this->dataHelper->getMailIncludeData($visform, 'receipt');
        }
        if ((!(empty($visform->dataRecordId))) && isset($visform->emailreceiptincdatarecordid) && ($visform->emailreceiptincdatarecordid == 1)) {
            $bodyData[] = Text::_('COM_VISFORMS_RECORD_SET_ID') . " : " . $visform->dataRecordId;
        }
        if (!isset($visform->emailreceiptincip) || (isset($visform->emailreceiptincip) && ($visform->emailreceiptincip == 1))) {
            $bodyData[] = Text::_('COM_VISFORMS_IP_ADDRESS') . " : " . $_SERVER['REMOTE_ADDR'];
        }
        $bodyData = implode('<br />', $bodyData);
        if (!empty($bodyData)) {
            $mailBody .= '<p>' . $bodyData . '</p>';
        }

        // send the mail
        try {
            $mail = $this->mailer->createMailer();
            $mail->CharSet = "utf-8";
            // Attach files to email
            if (!empty($visform->emailreceiptincfile)) {
                for ($i = 0; $i < $n; $i++) {
                    $field = $visform->fields[$i];
                    if ($field->typefield == 'file' && isset($_FILES[$field->name]['name']) && $_FILES[$field->name]['name'] != '') {
                        if ($field->file['filepath'] != '') {
                            $attachmentName = $field->file['name'];
                            if (!empty($field->fileattachmentname)) {
                                $attachmentName = $this->getAttachementName($field->fileattachmentname, $attachmentName);
                            }
                            $mail->addAttachment($field->file['filepath'], $attachmentName);
                        }
                    }
                    else if ($field->typefield == 'file' && ($visform->emailreceiptincfile == "2") && !empty($field->orgfile->filepath)) {
                        if (!empty($field->fileattachmentname)) {
                            $attachmentName = $this->getAttachementName($field->fileattachmentname, $field->orgfile->filepath);
                            $mail->addAttachment($field->orgfile->filepath, $attachmentName);
                        }
                        else {
                            $mail->addAttachment($field->orgfile->filepath);
                        }
                    }
                }
            }
            $emailreceiptsubject = $model->replacePlaceholder($visform, $visform->emailreceiptsubject);
            $replacedEMailFromName = $model->replacePlaceholder($visform, trim($visform->emailreceiptfromname), array('email', 'text', 'hidden'));
            $mail->addRecipient($emailReceiptTo);
            if (trim($visform->emailreceiptcc) !== '') {
                $replacedMailCcs = $this->replacePlaceholderInMailAdressParameter('emailreceiptcc');
                if (!empty($replacedMailCcs)) {
                    $mail->addCC($replacedMailCcs);
                }
            }
            if (trim($visform->emailreceiptbcc) !== '') {
                $replacedMailBccs = $this->replacePlaceholderInMailAdressParameter('emailreceiptbcc');
                if (!empty($replacedMailBccs)) {
                    $mail->addBCC($replacedMailBccs);
                }
            }
            if (trim($visform->emailreceiptfrom) !== '') {
                $replacedMailFromAddress = $model->replacePlaceholder($visform, trim($visform->emailreceiptfrom), array('email'), true);
                $mail->setSender(array(((!empty($replacedMailFromAddress)) ? $replacedMailFromAddress : $visform->emailreceiptfrom), $replacedEMailFromName));
            }
            if (!empty(AefHelper::checkAEF())) {
                if (trim($visform->emailreceiptreplyto) !== '') {
                    $replacedReplyToAddress = $model->replacePlaceholder($visform, trim($visform->emailreceiptreplyto), array('email'), true);
                    $mail->addReplyTo(((!empty($replacedReplyToAddress)) ? $replacedReplyToAddress : $visform->emailreceiptreplyto), $replacedEMailFromName);
                }
            }
            $mail->setSubject($emailreceiptsubject);
            $mail->IsHTML(true);
            $mail->Encoding = 'base64';
            $mail->setBody($mailBody);
            $emailPrepareEvent = new VisformsEmailPrepareEvent('onVisformsEmailPrepare', [
                'subject' => $mail,
                'context' => 'com_visforms.form.receiptmail',
                'form' => $visform,
            ]);
            $model->getDispatcher()->dispatch('onVisformsEmailPrepare', $emailPrepareEvent);
            if (!empty($visform->emailreceiptloggingtype)) {
                // add success logging
                // one entry for each mail address
                $mailRecipientAdresses = $mail->getAllRecipientAddresses();
                foreach ($mailRecipientAdresses as $adress => $success) {
                    $this->addLogEntry(Text::sprintf('COM_VISFORMS_LOG_MAIL_SUCCESS', Text::_('COM_VISFORMS_RECEIPT_MAIL'), $visform->id, $adress) , Log::INFO);
                }
            }
            $mail->Send();
            // Log
            // for each mail address one row
        }
        catch (\Exception $e) {
            // the user email could not be send
            $this->addLogEntry(Text::sprintf('COM_VISFORMS_LOG_MAIL_FAILURE', Text::_('COM_VISFORMS_RECEIPT_MAIL'), $visform->id, $e->getMessage()), Log::WARNING);
        }
        return true;
    }

    protected function setDataHelper(): bool {
        if ($this->view === 'visforms') {
            $this->dataHelper = new FormMailDataHelper($this->form, $this->type);
            return true;
        }
        else if ($this->view === 'edit') {
            $this->dataHelper = new EditMailDataHelper($this->form, $this->type);
            return true;
        }
        // // Log Error Message in log file
        return false;
    }

    // mail address parameter may contain multiple email addresses which are then separated by comma
    // mailer object supports mailto, mailcc and mailbcc to be either comma separated strings or array
    // $name: string of comma separated mail addresses or placeholder for mail addresses
    // returns array of mail addresses, with all placeholders replaced
    protected function replacePlaceholderInMailAdressParameter($name) {
        $model = $this->model;
        $visform = $this->form;
        $replacedMailAddresses = array();
        if (empty($visform->$name)) {
            return $replacedMailAddresses;
        }
        $mailAddresses = explode(",", $visform->$name);
        foreach ($mailAddresses as $mailAdress) {
            $replacedMail = $model->replacePlaceholder($visform, trim($mailAdress), array('email','text','hidden'), true);
            if (!empty($replacedMail)) {
                // validate that replace value has a valid mail address format
                $validation = new EmailValidation(array('value' => $replacedMail));
                if ($validation->validate()) {
                    $replacedMailAddresses[] = $replacedMail;
                }
            }
        }
        return $replacedMailAddresses;
    }

    protected function getAttachementName($atmName, $uploadName) {
        $visform = $this->form;
        $model = $this->model;
        if (empty($atmName)) {
            return $atmName;
        }
        $fileExt = File::getExt($uploadName);
        $attachmentName = $model->replacePlaceholder($visform, $atmName) . '.' . $fileExt;
        return File::makeSafe($attachmentName);
    }

    // remove marked emtyp elements from HTML
    protected function deleteIfEmpty($text) {
        $helper = new DeleteIfEmpty($text);
        return $helper->deleteIfEmpty();
    }
}