<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;
use Visolutions\Component\Visforms\Administrator\Helper\AefHelper;
use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper;

$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));
$layout = $this->getLayout();
$hasSub = AefHelper::checkAEF();
$canEdit =  ($this->canDo->get('core.edit.data') && $hasSub);
$canEditOwn =  ($this->canDo->get('core.edit.own.data') && $hasSub);
$canPublish = ($this->canDo->get('core.edit.data.state') && $hasSub);
$canPublishOwn = ($this->canDo->get('core.edit.own.data.state') && $hasSub);
$canExportCsv = ($this->canDo->get('core.export.data.frontend') && $hasSub && !empty($this->visform->display_csv_export_button) && !empty($this->items));
$hasCsvExport = (($layout === 'dataeditlist' || $layout === 'data') && $canExportCsv);
$redirectUri = '&return=' . HTMLHelper::_('visforms.base64_url_encode', Uri::getInstance()->toString());
$i = 0;
$maxTextLength = $this->menu_params->get('maxTextLength', 255);
$pParams = array();
$user = $this->getCurrentUser();

 // listbox document download
echo LayoutHelper::render('visforms.datas.actionbar.select-datalist-download', array('user' => $user, 'form' => $this->visform, 'pdfTemplates' => $this->pdfTemplates, 'addCsv' => $hasCsvExport), null, array('component' => 'com_visforms'));
?>

<table class="visdatatabledatavertical visdata visdatatable jlist-table<?php
if (isset($this->menu_params['show_tableborder']) && $this->menu_params['show_tableborder'] == 1) {
	echo " visdatatableborder";
}
if (isset($this->menu_params['viewclass'])) {
	echo " " . $this->menu_params['viewclass'];
} ?>
    "><?php
	if (isset($this->menu_params['show_columnheader']) && $this->menu_params['show_columnheader'] == 1) { ?>
		<thead>
	<tr><?php
		if (!empty($this->visform->displaycounter)) {
			echo '<'.$this->labelHtmlTag.'></'.$this->labelHtmlTag.'>';
		}
		echo LayoutHelper::render('visforms.datas.labels.id', array('form' => $this->visform, 'label' => 'COM_VISFORMS_ID', 'name' => 'displayid', 'listDirn' => $listDirn, 'listOrder' => $listOrder, 'extension' => $this->extension, 'htmlTag' => $this->labelHtmlTag, 'class' => $this->labelClass . ' data-id', 'context' => $this->uniqueContext), null, array('component' => 'com_visforms'));
		if ($layout === 'dataeditlist') {
			if ($canEdit || $canEditOwn) {
				echo '<'.$this->labelHtmlTag.' width="3%" class="'.$this->labelClass.' data-edit"></'.$this->labelHtmlTag.'>';
			}
			if ($canPublish || $canPublishOwn) {
				echo '<'.$this->labelHtmlTag.' class="'.$this->labelClass.' data-publish"></'.$this->labelHtmlTag.'>';
			}
		}

		// create a table head for each pdf tmpl for which the user can download a pdf for at least one record
		foreach ($this->singleRecordPdfTmplDisplay_list as $display) {
		    // display is an array with a list of all items for which the user can download this pdf (so it may be empty)
		    if ($display) {
                echo '<' . $this->labelHtmlTag . ' class="' . $this->labelClass . ' data-pdf"></' . $this->labelHtmlTag . '>';
            }
        }
		foreach ($this->fields as $rowField) {
			if (!empty($rowField->useassearchfieldonly)) {
				continue;
			}
			if (isset($rowField->frontdisplay) && ($rowField->frontdisplay == 1 || $rowField->frontdisplay == 2)) {
				echo LayoutHelper::render('visforms.datas.labels.column', array('form' => $this->visform, 'label' => $rowField->label, 'dbName' => 'F'. $rowField->id, 'listDirn' => $listDirn, 'listOrder' => $listOrder, 'extension' => $this->extension, 'htmlTag' => $this->labelHtmlTag, 'class' => $this->labelClass . ' data-f' . $rowField->id, 'context' => $this->uniqueContext, 'unSortable' =>  $rowField->unSortable), null, array('component' => 'com_visforms'));
			}
		}
		echo LayoutHelper::render('visforms.datas.labels.column', array('form' => $this->visform, 'label' => Text::_('COM_VISFORMS_IP_ADDRESS'), 'name' => 'displayip', 'dbName' => 'ipaddress', 'listDirn' => $listDirn, 'listOrder' => $listOrder, 'extension' => $this->extension, 'htmlTag' => $this->labelHtmlTag, 'class' => $this->labelClass . ' data-ip', 'context' => $this->uniqueContext), null, array('component' => 'com_visforms'));
		echo LayoutHelper::render('visforms.datas.labels.column', array('form' => $this->visform, 'label' => Text::_('COM_VISFORMS_MODIFIED'), 'name' => 'displayismfd', 'dbName' => 'ismfd', 'listDirn' => $listDirn, 'listOrder' => $listOrder, 'extension' => $this->extension, 'htmlTag' => $this->labelHtmlTag, 'class' => $this->labelClass . ' data-mfd', 'context' => $this->uniqueContext), null, array('component' => 'com_visforms'));
		echo LayoutHelper::render('visforms.datas.labels.column', array('form' => $this->visform, 'label' => Text::_('COM_VISFORMS_SUBMISSIONDATE'), 'name' => 'displaycreated', 'dbName' => 'created', 'listDirn' => $listDirn, 'listOrder' => $listOrder, 'extension' => $this->extension, 'htmlTag' => $this->labelHtmlTag, 'class' => $this->labelClass . ' data-created', 'context' => $this->uniqueContext), null, array('component' => 'com_visforms'));
        echo LayoutHelper::render('visforms.datas.labels.column', array('form' => $this->visform, 'label' => Text::_('COM_VISFORMS_CREATED_BY'), 'name' => 'displaycreatedby', 'dbName' => 'creator', 'listDirn' => $listDirn, 'listOrder' => $listOrder, 'extension' => $this->extension, 'htmlTag' => $this->labelHtmlTag, 'class' => $this->labelClass . ' data-created-by', 'context' => $this->uniqueContext, 'tableAlias' => ''), null, array('component' => 'com_visforms'));
		echo LayoutHelper::render('visforms.datas.labels.column', array('form' => $this->visform, 'label' => Text::_('COM_VISFORMS_MODIFICATION_DATE'), 'name' => 'displaymodifiedat', 'dbName' => 'modified', 'listDirn' => $listDirn, 'listOrder' => $listOrder, 'extension' => $this->extension, 'htmlTag' => $this->labelHtmlTag, 'class' => $this->labelClass . ' data-modifiedat', 'context' => $this->uniqueContext), null, array('component' => 'com_visforms'));
        echo LayoutHelper::render('visforms.datas.labels.column', array('form' => $this->visform, 'label' => Text::_('COM_VISFORMS_MODIFIED_BY'), 'name' => 'displaymodifiedby', 'dbName' => 'editor', 'listDirn' => $listDirn, 'listOrder' => $listOrder, 'extension' => $this->extension, 'htmlTag' => $this->labelHtmlTag, 'class' => $this->labelClass . ' data-modified-by', 'context' => $this->uniqueContext, 'tableAlias' => ''), null, array('component' => 'com_visforms'));
		?>
	</tr>
		</thead><?php
	}
	if (!empty($this->items)) {
	foreach ($this->items as $row) {
		$link = Route::_( 'index.php?option=com_visforms&view=visformsdata&layout='.$this->detailLinkLayout.'&id='.$this->id.'&cid='.$row->id.'&Itemid='.$this->itemid . $this->tmplQuery); ?>
		<tr class="sectiontableentry1"><?php
		if (!empty($this->visform->displaycounter)) {
			echo '<'.$this->valueHtmlTag.'>'.++$this->displayCounter.'</'.$this->valueHtmlTag.'>';
		}
		echo LayoutHelper::render('visforms.datas.fields.id', array('form' => $this->visform, 'data' => $row, 'link' => $link, 'extension' => $this->extension, 'htmlTag' => $this->valueHtmlTag, 'class' => $this->valueClass . ' data-id', 'viewType' => $this->viewType, 'cbIndex' => $i), null, array('component' => 'com_visforms'));
		if ($layout === 'dataeditlist') {
			if ($canEdit || $canEditOwn) {
				$editUrl = Uri::base() . 'index.php?option=com_visforms&view=edit&layout=edit&task=edit.editdata&id=' . (int) $this->visform->id . '&cid=' . (int) $row->id . $redirectUri . '&Itemid='.$this->itemid . $this->tmplQuery;
				echo '<'.$this->valueHtmlTag.'>';
				if (($canEdit || (isset($row->created_by) && $row->created_by === $user->id))
                    // Only display Edit link for unpublish record set, if a user also has the permission to publish the record set
                    && ((!empty($row->published)) || ((empty($row->published)) && ($canPublish || ($canPublishOwn && isset($row->created_by) && $row->created_by === $user->id))))) {
					echo '<a class="visToolTip" href="' . $editUrl . '" title="'.htmlspecialchars(Text::_('COM_VISFORMS_EDIT'), ENT_COMPAT).'" data-bs-toogle="tooltip"><i class="visicon-edit" aria-hidden="true"></i></a>';
				}
				echo '</'.$this->valueHtmlTag.'>';
			}
			if ($canPublish || $canPublishOwn) {
				echo '<'.$this->valueHtmlTag.'>';
                if ($canPublish || ( isset($row->created_by) && $row->created_by === $user->id)) {
                    HTMLHelper::_('visforms.loadDataTaskJs');
                    if ($row->published) { ?>
                    <a class="btn btn-micro active visToolTip vfdv-task" href="#" title="<?php echo htmlspecialchars(Text::_('JLIB_HTML_UNPUBLISH_ITEM'), ENT_COMPAT); ?>"  data-bs-toogle="tooltip" data-item-id="cb<?php echo $i; ?>" data-item-task="visformsdata.unpublish" data-item-context="<?php echo $this->uniqueContext; ?>">
                            <span class="visicon-publish" aria-hidden="true"></span>
                        </a><?php
                    } else { ?>
                    <a class="btn btn-micro active visToolTip vfdv-task"  href="#" title="<?php echo htmlspecialchars(Text::_('JLIB_HTML_PUBLISH_ITEM'), ENT_COMPAT); ?>"  data-bs-toogle="tooltip" data-item-id="cb<?php echo $i; ?>" data-item-task="visformsdata.publish" data-item-context="<?php echo $this->uniqueContext; ?>">
                            <span class="visicon-unpublish" aria-hidden="true"></span>
                        </a><?php
                    }
                }
				echo '</'.$this->valueHtmlTag.'>';
			}

		}
        foreach ($this->singleRecordPdfTmplDisplay_list as $singleRecordPdfTmplId => $display) {
            // display is an array with a list of all items for which the user can download this pdf (so it may be empty)
            if ($display) {
                $tooltip = (!empty($text = VisformsHelper::getPdfDownlaodLinkTitle($singleRecordPdfTmplId, $this->pdfTemplates))) ? Text::sprintf('COM_VISFORMS_DOWNLOAD_AS_PDF_TEXT_FOR_NAMED_DOCUMENT', $text) : Text::_('COM_VISFORMS_DOWNLOAD_PDF');
                if (in_array($row->id, $display)) {
                    echo LayoutHelper::render('visforms.datas.fields.pdfbutton', array('form' => $this->visform, 'id' => $row->id, 'extension' => $this->extension, 'htmlTag' => $this->valueHtmlTag, 'class' => $this->valueClass . ' data-pdf', 'viewType' => $this->viewType, 'title' => $tooltip, 'data-item-id' => 'cb' .$i, 'data-item-task' => 'visformsdata.renderPdf_' . $singleRecordPdfTmplId, 'data-item-context' => $this->uniqueContext), null, array('component' => 'com_visforms'));
                }
                else {
                    echo '<' . $this->valueHtmlTag . '></' . $this->valueHtmlTag . '>';
                }
            }
        }
		foreach ($this->fields as $rowField) {
			if (!empty($rowField->useassearchfieldonly)) {
				continue;
			}
			if (isset($rowField->frontdisplay) && ($rowField->frontdisplay == 1 || $rowField->frontdisplay == 2)) {
				$prop="F".$rowField->id;
				$texte = (isset($row->$prop)) ? $row->$prop : '';
				if ($rowField->typefield == 'textarea') {
                    $pParams['maxtextlength'] = $maxTextLength;
                }
				echo $texte = LayoutHelper::render('visforms.datas.fields', array('form' => $this->visform, 'field' => $rowField, 'data' => $row, 'text' => $texte, 'htmlTag' => $this->valueHtmlTag, 'class' => $this->valueClass . ' data-f' . $rowField->id, 'extension' => $this->extension, 'view' => 'list', 'viewType' => $this->viewType, 'pparams' => $pParams), null, array('component' => 'com_visforms'));
			}
		}
		echo LayoutHelper::render('visforms.datas.fields.defaultoverhead', array('form' => $this->visform, 'text' => $row->ipaddress, 'name' => 'displayip', 'extension' => $this->extension, 'htmlTag' => $this->valueHtmlTag, 'class' => $this->valueClass . ' data-ip', 'viewType' => $this->viewType), null, array('component' => 'com_visforms'));
		echo LayoutHelper::render('visforms.datas.fields.ismfd', array('form' => $this->visform, 'text' => $row->ismfd, 'extension' => $this->extension, 'htmlTag' => $this->valueHtmlTag, 'class' => $this->valueClass . ' data-mfd', 'viewType' => $this->viewType), null, array('component' => 'com_visforms'));
		echo LayoutHelper::render('visforms.datas.fields.created', array('form' => $this->visform, 'data' => $row, 'extension' => $this->extension, 'htmlTag' => $this->valueHtmlTag, 'class' => $this->valueClass . ' data-created', 'viewType' => $this->viewType), null, array('component' => 'com_visforms'));
        echo LayoutHelper::render('visforms.datas.fields.defaultoverhead', array('form' => $this->visform, 'text' => $row->creator, 'name' => 'displaycreatedby', 'extension' => $this->extension, 'htmlTag' => $this->valueHtmlTag, 'class' => $this->valueClass . ' data-created-by', 'viewType' => $this->viewType), null, array('component' => 'com_visforms'));
		echo LayoutHelper::render('visforms.datas.fields.modifiedat', array('form' => $this->visform, 'data' => $row, 'extension' => $this->extension, 'htmlTag' => $this->valueHtmlTag, 'class' => $this->valueClass . ' data-modifiedat', 'viewType' => $this->viewType), null, array('component' => 'com_visforms'));
        echo LayoutHelper::render('visforms.datas.fields.defaultoverhead', array('form' => $this->visform, 'text' => $row->editor, 'name' => 'displaymodifiedby', 'extension' => $this->extension, 'htmlTag' => $this->valueHtmlTag, 'class' => $this->valueClass . ' data-modified-by', 'viewType' => $this->viewType), null, array('component' => 'com_visforms'));
		?>

		</tr><?php
		$i++;
    }
	} ?>
</table>