<?php
/**
 * @author       Aicha Vack
 * @package     Joomla.Administrator
 * @subpackage  com_content
 * @link         https://www.vi-solutions.de
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Visolutions\Component\Visforms\Administrator\Controller;

defined('_JEXEC') or die( 'Restricted access' );

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\Input\Input;

class VisfieldController extends ItemControllerBase
{
	public function __construct($config = array(), ?MVCFactoryInterface $factory = null, ?CMSApplicationInterface $app = null, ?Input $input = null) {
		parent::__construct($config, $factory, $app, $input);
	}

	public function batch($model = null) {
		Session::checkToken() or jexit(Text::_('JINVALID_TOKEN'));
		// set the model
		$model = $this->getModel('Visfield', '', array());
		// preset the redirect
		$this->setRedirect(Route::_('index.php?option=com_visforms&view=visfields' . $this->getRedirectToListAppend(), false));
		return parent::batch($model);
	}
	
	protected function postSaveHook(BaseDatabaseModel $model, $validData = array()) {
		$model->assureCreateDataTableFields();
	}
	
	protected function getRedirectToItemAppend($recordId = null, $urlVar = 'id') {
		$fid = $this->input->getInt('fid', 0);
		$append = parent::getRedirectToItemAppend($recordId);
		$append .= '&fid=' . $fid.'&extension=com_visforms.visform.'.$fid;
		return $append;
	}
	
	protected function getRedirectToListAppend() {
		$fid = $this->input->getInt('fid', 0);
		$append = '';
		// setup redirect info
		if ($fid != 0) {
			$append .= '&fid=' . $fid;
		}
		parent::getRedirectToListAppend();
		return $append;
	}
	
	protected function allowEdit($data = array(), $key = 'id') {
		$recordId = (int) isset($data[$key]) ? $data[$key] : 0;
		$fid = $this->input->getInt('fid');
		$assetId = 'com_visforms.visform.' . $fid . '.visfield.' . $recordId;
		$user = $this->app->getIdentity();
		$userId = $user->id;
		// check general edit permission first
		if ($user->authorise('core.edit', $assetId)) {
			return true;
		}

		// fallback on edit.own
		// first test if the permission is available
		if ($user->authorise('core.edit.own', $assetId)) {
			// now test the owner is the user
			$ownerId = (int) isset($data['created_by']) ? $data['created_by'] : 0;
			if (empty($ownerId) && $recordId) {
				// need to do a lookup from the model
				$record = $this->getModel()->getItem($recordId);
				if (empty($record)) {
					return false;
				}
				$ownerId = $record->created_by;
			}

			// if the owner matches 'me' then do the test
			if ($ownerId == $userId) {
				return true;
			}
		}
		
		return false;
	}
}