<?php
/**
 * Visforms
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2025 vi-solutions
 * @since        Visforms 5.4.0
 */

namespace Visolutions\Component\Visforms\Administrator\Model\Helper;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Visolutions\Component\Visforms\Administrator\Helper\AefHelper;
use Visolutions\Component\Visforms\Site\Model\VisformsdataModel;

require_once JPATH_LIBRARIES . '/visolutions/simple_html_dom/simple_html_dom.php';

class DeleteIfEmpty {

	private string $text;

	public function __construct($text) {
		$this->text = $text;
	}

    // there is no function 'remove' in simple_html_dom
    // you can remove an HTML-Tag by setting its outertext property to ''
    public function deleteIfEmpty() {
	    $text = $this->text;
        if (empty($text)) {
            return '';
        }
        if (empty(AefHelper::checkAEF())) {
            return $text;
        }
        $html = str_get_html($text);
        // this use of 'find' actually works like the css attribute selector class~="die" with the ~,
        // which searches for the exact word in a string whitespace separated values
        $nodes = $html->find('[class="die"]');
        foreach ($nodes as $node) {
            $node->outertext = "";
        }
        $html->save();
        return trim($html);
    }
}