<?php
/**
 * viscpanel model for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

namespace Visolutions\Component\Visforms\Administrator\Model;

defined('_JEXEC') or die('Direct Access to this location is not allowed.');

use Joomla\Event\DispatcherAwareTrait;
use Joomla\Event\DispatcherInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\Database\DatabaseInterface;
use Joomla\CMS\Table\Extension;

class ViscpanelModel extends BaseDatabaseModel
{
	use DispatcherAwareTrait;
    public function __construct($config = array(), ?MVCFactoryInterface $factory = null) {
        parent::__construct($config, $factory);
    }

	public function getDispatcher() {
		if (!$this->dispatcher) {
			return Factory::getContainer()->get(DispatcherInterface::class);
		}
		return $this->dispatcher;
	}

    // dlid is stored in #__updates_sites extra_query for each vfsubsciption update site record
	// and in #__extensions com_visforms params record
	public function storeDlid() {
        $extensions = "('vfsubscription')";
        $dlId = $this->getState('dlid');
        $extra_query = (!empty($dlId)) ? "dlid=$dlId" : "";
        $return = true;
        $db = $this->getDatabase();
        $query = $db->createQuery()
            ->update('#__update_sites')
            ->set('extra_query = ' . $db->quote($extra_query))
            ->where('name in ' . $extensions);
        try {
	        $db->setQuery($query);
            $db->execute();
        }
        catch (\RuntimeException $e) {
            Factory::getApplication()->enqueueMessage($e->getMessage() . ' Problems saving download id', 'error');
            $return = false;
        }
        return $return;
    }

	public function storeDemoFormInstalled() {
		if (!$this->storeParam('demoFormInstalled', true)) {
			return false;
		}
		return true;
	}

    public function storeBfFormsImported() {
        if (!$this->storeParam('bfFormsImported', '1')) {
            return false;
        }
        return true;
    }

	public function getDlId() {
		$db = $this->getDatabase();
		$query = $db->createQuery();
		$query->select('extra_query')
			->from('#__update_sites')
			->where($db->quoteName('name') . ' = ' . $db->quote('vfsubscription'));
		try {
			$db->setQuery($query);
			$dlId = $db->loadResult();
			return substr($dlId ?? '', 5);
		}
		catch (\RuntimeException $e) {
			return '';
		}
	}

    protected function storeParam($name, $value) {
        $db = Factory::getContainer()->get(DatabaseInterface::class);
	    $component = ComponentHelper::getComponent('com_visforms');
	    $component->params->set($name, $value);
	    $componentId = $component->id;
	    $table = new Extension($db);
	    $table->load($componentId);
	    $table->bind(array('params' => $component->params->toString()));
	    if (!$table->check()) {
		    Factory::getApplication()->enqueueMessage('Invalid params', 'error');
		    return false;
	    }
	    if (!$table->store()) {
		    Factory::getApplication()->enqueueMessage('Problems saving params', 'error');
		    return false;
	    }
	    return true;
    }
}