<?php
/**
 * Vistools view for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

namespace Visolutions\Component\Visforms\Administrator\View\Vistools;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper;

/**
 * Vistools view
 *
 * @package    Visforms
 * @subpackage Components
 */
class HtmlView extends BaseHtmlView
{

	protected $state;
	protected $extension;
	protected mixed $form;
	protected $source;
	protected $file;
	protected $fileName;
	protected $type;
	protected $files;

	public function display($tpl = null)
	{
        // add apply and save button
		$app            = Factory::getApplication();
		$model = $this->getModel();
		$this->file     = $app->getInput()->get('file', '');
		$this->fileName = base64_decode($this->file);
		$explodeArray   = explode('.', $this->fileName);
		$ext            = end($explodeArray);
		$this->files    = $model->getFiles();
		$this->state    = $model->getState();

		$canDo    = VisformsHelper::getActions();
        if (!($canDo->get('core.edit.css'))) {
            Factory::getApplication()->redirect('index.php?option=com_visforms&view=visforms', Text::_('JERROR_ALERTNOAUTHOR'), 'warning');
        }

		$sourceTypes  = array('css');
		if (in_array($ext, $sourceTypes)) {
			$this->form   = $model->getForm();
			$this->form->setFieldAttribute('source', 'syntax', $ext);
			$this->source = $model->getSource();
			$this->type   = 'file';
		}
		else {
			$this->type = 'home';
		}

		// check for errors
		if (count($errors = $model->getErrors())) {
			$app->enqueueMessage(implode("\n", $errors));
			return false;
		}

		$this->addToolbar();
        VisformsHelper::addCommonViewStyleCss();

		parent::display($tpl);
	}

	protected function addToolbar()
	{
		$app = Factory::getApplication();
		$app->getInput()->set('hidemainmenu', true);
        $toolbar = $this->getDocument()->getToolbar();

        ToolbarHelper::title(Text::_('COM_VISFORMS_EDIT_CSS_BUTTON_TEXT'), 'visform');

		// add a new file button
        $toolbar->popupButton('file')
            ->text('COM_VISFORMS_BUTTON_FILE')
            ->icon('icon-file')
            ->selector('fileModal');
        if (!($this->type == 'home')) {
            // add rename file button
            $toolbar->popupButton('rename')
                ->text('COM_VISFORMS_BUTTON_RENAME_FILE')
                ->icon('icon-refresh')
                ->selector('renameModal');

            // add delete file button
            $toolbar->popupButton('delete')
                ->text('COM_VISFORMS_BUTTON_DELETE_FILE')
                ->icon('icon-remove')
                ->selector('deleteModal');
        }
        
		// add apply and save button
		if ($this->type == 'file') {
            ToolbarHelper::apply('vistools.apply');
            ToolbarHelper::save('vistools.save');
		}

		if ($this->type == 'home') {
            $toolbar->cancel('vistools.cancel', 'JTOOLBAR_CLOSE');
		}
		else {
            $toolbar->cancel('vistools.close', 'COM_VISFORMS_BUTTON_CLOSE_FILE');
		}
	}

	// called in tmps/default_tree.php if file structured is a nested tree
	protected function directoryTree($array)
	{
		$temp        = $this->files;
		$this->files = $array;
		$txt         = $this->loadTemplate('tree');
		$this->files = $temp;

		return $txt;
	}
}