<?php
/**
 * editor class	for visforms
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

namespace  Visolutions\Component\Visforms\Site\Helper;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

class EditorHelper {

    public static function initEditor() {
		$app =      Factory::getApplication();
		$doc =      $app->getDocument();
        $wa  = $doc->getWebAssetManager();
		$language = $app->getLanguage();

		$text_direction = $language->isRTL() ? 'rtl' : 'ltr';
		$langMode = 1;
		$langPrefix = ($langMode == 1) ? substr($language->getTag(), 0, strpos($language->getTag(), '-')) : 'en';
		$newLines = 1;
		if ($newLines) {
			// br
			// "force_br_newlines : true, force_p_newlines : false, forced_root_block : '',";
			$force_br_newlines  = 'true';
			$force_p_newlines   = 'false';
			$forced_root_block  = '';
		} else {
			// p
			// "force_br_newlines : false, force_p_newlines : true, forced_root_block : 'p'";
			$force_br_newlines  = 'false';
			$force_p_newlines   = 'true';
			$forced_root_block  = "p";
		}
		$root = Uri::root();

		// create the JavaScript script
        // we use the vendor tinymce script directly, not the plg_editor_tinymce
		$scripts = <<<JS

function initTinyMCE() {    
    // console.log('initTinyMCE');
    tinyMCE.init({
        // general
        promotion: 			false,
        branding: 			false,
        directionality: 	"$text_direction",
        plugins: 			"autosave charmap",
        language: 			"$langPrefix",
        // use custom <select nme="" id=""></select>or, added to textarea element in components/com_visforms/lib/html/field/textarea.php
        selector: 			".visforms-editor-tinymce",
        mode: 				"specific_textareas",
        deselector: 		"visforms-editor-tinymce",
        schema: 			"html5",
        // cleanup / output
        inline_styles: 		true,
        gecko_spellcheck: 	true,
        entity_encoding: 	"raw",
        // force new line    
        force_br_newlines: 	'$force_br_newlines',
        force_p_newlines: 	'$force_p_newlines',
        forced_root_block: 	'$forced_root_block',
        // UR
        relative_urls: 		false,
        remove_script_host: false,
        // layout                 
        document_base_url: 	"$root",
        menubar: "insert",
        license_key: "gpl",
        setup: function (ed) {
            ed.on('change', function (ed) { updateText(ed); });
            // add function that will update content of tinyMCE on submit
            ed.on('submit', function (ed) { return updateText(ed); });
            // ed.on('init', function (ed) { console.log('editor: on init'); });
        }
    })
}
function updateText(ed) {
    // get id of textarea which belongs to the editor
    const inputId = ed.target.id;
    // copy editor content into textarea
    tinyMCE.triggerSave();
    // validate content of textarea
    return jQuery('#' + inputId).valid();
}

JS;
		// repair boolean 'true' and 'false' values in tinymce init() settings
		// the 'true' and 'false' values in tinymce init() settings are necessary in order to comply with the IDE language parsing
		// --> there would be huge parsing errors instead
		$scripts = str_replace("'true'", 'true', $scripts);
		$scripts = str_replace("'false'", 'false', $scripts);
		$wa->registerAndUseScript('visforms.tinymce', "media/vendor/tinymce/tinymce.min.js", [], ['defer' => true]);
        $wa->addInlineScript($scripts);

		return true;
	}
}
