<?php
/**
 * Visforms field file business class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Business;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Visolutions\Component\Visforms\Site\Lib\Message\RequiredUploadMessage;
use Visolutions\Component\Visforms\Administrator\Helper\MediaHelper;

class FileFieldBusiness extends Business
{
	public function getFields() {
		$this->setField();
		return $this->fields;
	}

	protected function setField() {
		$this->setIsDisabled();
		if (isset($this->field->dataSource) && $this->field->dataSource == 'post') {
			$this->validatePostValue();
		}
		$this->addShowWhenForForm();
		$this->setFileInfo();
	}

	protected function validatePostValue(): void {
		// upload fields do not have a post value
	}

	public function validateRequired() {
		if (isset($this->field->dataSource) && $this->field->dataSource == 'post') {
			$app = Factory::getApplication();
			// check that a value is set if field is required
			if (isset($this->field->attribute_required)) {
				if (empty($this->field->isDisabled)) {
					// if we are in the data edit mode we assume that a required file upload field has a value,
					// and we only have to make sure that a new file is uploaded if the old one is deleted
					$deleteFlagId = $this->field->name . '-filedelete';
					$deleteFlagValue = $app->getInput()->get($deleteFlagId);
					if ((empty($this->field->recordId)) || (!empty($deleteFlagValue))) {
						if ((isset($_FILES[$this->field->name]['name']) === false) || (isset($_FILES[$this->field->name]['name']) && $_FILES[$this->field->name]['name'] == '')) {
							$this->field->isValid = false;
                            $message = new RequiredUploadMessage($this->field->label, $this->field->custom_php_error);
                            $error = $message->getMessage();
							$this->setErrors($error);
						}
					}
				}
			}
		}
		return $this->field;
	}
	// if we are editing record set, we gather information of the old file and store it with the field, in order that we can display file information in edit form
	// $file->orgFile information is used in layouts files i.e. layouts/visforms/edit/file/control.php of all edit layouts
	// file information is stored as json object of file name and file path in database
	protected function setFileInfo() {
		// only set, if we are in an "edit" kind of view
		if (empty($this->field->recordId)) {
			return;
		}
		$data = $this->form->data;
		$dataFieldName = 'F' . $this->field->id;
		$dbValue = $data->$dataFieldName;
		if (empty($dbValue)) {
			return;
		}
		$file = MediaHelper::getFileInfo($dbValue);
		if (!empty($file)) {
			$this->field->orgfile = $file;
		}
	}
}