<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Control;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Layout\LayoutHelper;

class Bt5SignatureControl extends Control
{
	public function getControlHtml() {
		$field = $this->field->getField();
		$field->clabel = $this->createlabel();
		$field->ccustomtext = $this->getCustomText();
		$field->inverseBtLabelClasses = $this->getCtClasses();
		$field->ctrlGroupBtClasses = $this->getCtrlGroupBtClasses();
		return LayoutHelper::render('visforms.bt5.signature.control', array('field' => $field), null, array('component' => 'com_visforms'));
	}

	public function createLabel() {
		$field = $this->field->getField();
		$labelClass = $this->getLabelClass();
		$field->labelClass = $labelClass;
		return LayoutHelper::render('visforms.bt5.signature.label', array('field' => $field), null, array('component' => 'com_visforms'));
	}

	protected function getCtrlGroupBtClasses() {
		$field = $this->field->getField();
        // show_label: 0 => show 1 => hide !
        $hasNoLabel = ((!empty($field->show_label)) && (empty($field->label_icon)));
		$classes = ($hasNoLabel && $field->labelBootstrapWidth != "12") ? 'offset-' . $field->labelBootstrapWidth . ' col-' . (12 - $field->labelBootstrapWidth) : (($field->labelBootstrapWidth != "12") ? ' col-' . (12 - $field->labelBootstrapWidth) : ' col-12');
		foreach ($this->breakPoints as $breakPoint) {
			$name = 'labelBootstrapWidth' . $breakPoint;
			$lcBreakPoint = lcfirst($breakPoint);
			$classes .= ($hasNoLabel && $field->$name != "12") ? ' offset-' . $lcBreakPoint . '-' . $field->$name . ' col-' . $lcBreakPoint . '-' . (12 - $field->$name) : (((!$hasNoLabel) && $field->$name != "12") ? ' col-' . $lcBreakPoint . '-' . (12 - $field->$name) : '');
		}
		return $classes;
	}
}