<?php
/**
 * Visforms HTML class for text fields
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

class TextField extends BaseHtmlField
{
	public function __construct($field, $decorable, $attribute_type) {
		if (is_null($attribute_type)) {
			$attribute_type = "text";
		}
		// prevent email-cloaking in form displayed in content, when a default value which is an email address is set
		if (isset ($field->attribute_value) && ($field->attribute_value != "")) {
			$field->attribute_value = str_replace('@', '&#64', $field->attribute_value);
		}
		parent::__construct($field, $decorable, $attribute_type);
	}

	public function getFieldAttributeArray() {
		$attributeArray = array('class' => '');
		if (!empty($this->field->disableEnterKey)) {
			$attributeArray['class'] = 'noEnterSubmit ';
		}
		// HTML attributes are stored in xml-definition-fields with name that ends on _attribute_attributename (i.e. _attribute_checked)
        // names from xml field definition are used, to create the HTML attributes for the control
		// in the xml-definition file each form field is represented by a fieldset
		// in the xml-definition file each form field should have a xml-definition-field with a name that ends on _attribute_class
        // the following code converts the xml-definition-field-names to HTML attribute names and sets the values for the HTML attributes
		foreach ($this->field as $name => $value) {
			if (!is_array($value)) {
				if (str_contains($name, 'attribute_')) {
					if ($name == 'attribute_required') {
						$attributeArray['aria-required'] = 'true';
					}
					// Process if
                    // the value for the attribute option is not empty
                    // or it is the class attribute
                    // or it is the value attribute
                    // or it is the min attribute and the value is set to 0
                    // if a min validation value greater 0 is set, $value is a numeric string 'number' > 0 and therefore true
                    // if a min validation value equal to 0 is set, ($name == 'attribute_min' && (int) $value === 0) is true
					if ($value || $name == 'attribute_class' || ($name == 'attribute_min' && (int) $value === 0) || ($name == 'attribute_value')) {
						$newname = str_replace('attribute_', "", $name);
						if ($newname == "class") {
							$value = $attributeArray[$newname] . $value . (!empty($value) ? ' ' : '') . $this->field->fieldCSSclass;
							$attributeArray[$newname] .= $value;
						}
                        else if ($newname == 'placeholder' && !empty($value)) {
                            $attributeArray[$newname] = str_replace('@', '&#64', $value);
                        }
						else {
							$attributeArray[$newname] = $value;
						}
					}
				}
				if ($name == 'name') {
					$attributeArray['name'] = $value;
				}
				if ($name == 'id') {
					$value = 'field' . $value;
					$attributeArray['id'] = $value;
					$attributeArray['data-error-container-id'] = 'fc-tbx' . $value;
				}
				if (($name == 'isDisabled') && ($value == true)) {
					$attributeArray['class'] .= " ignore";
					$attributeArray['disabled'] = "disabled";
				}
				if (($name == 'isDisplayChanger') && ($value == true)) {
					$attributeArray['class'] .= " displayChanger";
				}
				if (($name == 'isValid') && ($value == false)) {
					$attributeArray['class'] .= " error";
				}
				$attributeArray['aria-labelledby'] = $this->field->name . 'lbl';
			}
		}
		return $attributeArray;
	}

    // bootstrap 5
    public function setControlBt5HtmlClasses($field) {
        $field->attribute_class = " form-control";
        return $field;
    }

	// uikit 3
	public function setUikit3ControlHtmlClasses($field) {
		$field->attribute_class = " uk-input";
		return $field;
	}
}