<?php
/**
 * Visforms Layout class Bootstrap default
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Layout;

// no direct access
defined('_JEXEC') or die('Restricted access');
use Visolutions\Component\Visforms\Site\Lib\Html\Control\ControlAwareTrait;
use Visolutions\Component\Visforms\Site\Lib\Html\Control\Decorator\Bt5EditDecorator;

class Bt5EditLayout extends Bt5Layout
{
    use ControlAwareTrait;
	public function prepareHtml() {
		// attach error messages array for javascript validation to field
		$this->setFieldCustomErrorMessageArray();
		$this->cleanFieldProperties();
		$this->getFieldGroupBootstrapClasses();
		$this->setControlBt5HtmlClasses();
        $this->setToolTip();
		$this->setErrorId();
		// handle forbidden fields which cannot be edited
		$this->makeFieldUneditable();
		$this->setFieldAttributeArray();
		$this->setFieldValidateArray();
		$this->setFieldControlHtml();
		return $this->field;
	}

	protected function setControlBt5HtmlClasses() {
		if (method_exists($this->fieldHtml, 'setControlBt5HtmlClasses')) {
			$this->field = $this->fieldHtml->setControlBt5HtmlClasses($this->field);
		} 
		else {
			// use default
			foreach ($this->field as $name => $value) {
				if (!is_array($value)) {
					if (str_contains($name, 'attribute_class')) {
						$this->field->$name = "form-control ";
					}
				}
			}
		}
	}


	protected function setFieldControlHtml() {
		// get Instance of field html control class occoriding to field type and layout type
		// $ocontrol = VisformsHtmlControl::getInstance($this->fieldHtml, $this->type);
        $this->setControl($this->fieldHtml, $this->type);
        $ocontrol = $this->getControl();
		if (!(is_object($ocontrol))) {
			// throw an error
		} 
		else {
			// instanciate decorators
			$control = new Bt5EditDecorator($ocontrol);
		}
		//set field property
		$this->field->controlHtml = $control->getControlHtml();
	}
}