<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2019 vi-solutions
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Layout;

// no direct access
defined('_JEXEC') or die('Restricted access');
use Visolutions\Component\Visforms\Site\Lib\Html\Control\ControlAwareTrait;
use Visolutions\Component\Visforms\Site\Lib\Html\Control\Decorator\Uikit3Decorator;

class Uikit3Layout extends HtmlLayout
{
    use ControlAwareTrait;
	public function prepareHtml() {
		//attach error messages array for javascript validation to field
		$this->setFieldCustomErrorMessageArray();
		$this->cleanFieldProperties();
		$this->getFieldGroupUikitClasses();
		$this->setUikit3ControlHtmlClasses();
		$this->setToolTip();
		$this->setErrorId();
		$this->setFieldAttributeArray();
		$this->setFieldValidateArray();
		$this->setFieldControlHtml();
		return $this->field;
	}

    protected function setToolTip() {
        // add Attributes necessary to display a bootstrap tootip
        if (method_exists($this->fieldHtml, 'setToolTip')) {
            $this->field = $this->fieldHtml->setToolTip($this->field);
        }
        else {
            if (!empty($this->field->custominfo)) {
                $this->field->attribute_title = htmlspecialchars($this->field->custominfo, ENT_COMPAT, 'UTF-8');
                $this->field->{'attribute_data-uk-tooltip'} = "{pos:'top'}";
            }
        }
    }

	protected function setUikit3ControlHtmlClasses() {
		// ToDo check if we need to set this in every field class, because there is no default...
		if (method_exists($this->fieldHtml, 'setUikit3ControlHtmlClasses')) {
			// set uikit class attributes on html control element (like uk-input, uk-select, visToolTip...)
			$this->field = $this->fieldHtml->setUikit3ControlHtmlClasses($this->field);
		}
	}

	protected function setFieldControlHtml() {
		// get Instance of field html control class according to field type and layout type
		// $ocontrol = VisformsHtmlControl::getInstance($this->fieldHtml, $this->type);
        $this->setControl($this->fieldHtml, $this->type);
        $ocontrol = $this->getControl();
		if (!(is_object($ocontrol))) {
			//throw an error
		}
		else {
			// instanciate decorators
			$control = new Uikit3Decorator($ocontrol);
		}
		// set field property
		$this->field->controlHtml = $control->getControlHtml();
	}

	protected function cleanFieldProperties() {
		$breakpoints = array('Sm', 'Md', 'Lg', 'Xl');
		$this->field->attribute_class = "";
		if (!isset($this->field->show_label)) {
			$this->field->show_label = 0;
		}
		if (empty($this->field->fieldsPerRow) || ($this->subType != 'individual')) {
			$this->field->fieldsPerRow = "1";
		}
		if (empty($this->field->labelBootstrapWidth) || ($this->subType != 'individual')) {
			if ($this->subType == 'stacked' || $this->subType == 'individual') {
				$this->field->labelBootstrapWidth = "6";
			}
			else {
				$this->field->labelBootstrapWidth = "2";
			}
		}
		foreach ($breakpoints as $breakpoint) {
			$fieldsPerRow = 'fieldsPerRow' . $breakpoint;
			if (empty($this->field->$fieldsPerRow) || ($this->subType != 'individual')) {
				$this->field->$fieldsPerRow = "1";
			}
			$labelBootstrapWidth = 'labelBootstrapWidth' . $breakpoint;
			if (empty($this->field->$labelBootstrapWidth) || ($this->subType != 'individual')) {
				if ($this->subType == 'stacked' || $this->subType == 'individual') {
					$this->field->$labelBootstrapWidth = "6";
				}
				else {
					$this->field->$labelBootstrapWidth = "2";
				}
			}
		}
        if ($this->subType === 'horizontal' && isset($this->field->customtextposition) && ($this->field->customtextposition == 1)) {
            $this->field->customtextposition = 0;
        }
        //  or in individual layouts where label width is set to 12/12 for all! breakpoints
        else if ($this->subType === 'individual' && isset($this->field->customtextposition) && ($this->field->customtextposition == 1)) {
            foreach ($breakpoints as $breakpoint) {
                $labelBootstrapWidth = 'labelBootstrapWidth' . $breakpoint;
                if ($this->field->$labelBootstrapWidth != "6") {
                    $this->field->customtextposition = 0;
                    break;
                }
            }
        }
		if (!isset($this->field->custominfo)) {
			$this->field->custominfo = "";
		}
	}

	protected function getFieldGroupUikitClasses() {
		$this->field->fieldGroupUikit3Classes = 'uk-width-1-' . ($this->field->fieldsPerRow);
		if ($this->field->fieldsPerRowSm != "1") {
			$this->field->fieldGroupUikit3Classes .= ' uk-width-1-' . ($this->field->fieldsPerRowSm) . '@s';
		}
		if ($this->field->fieldsPerRowMd != "1") {
			$this->field->fieldGroupUikit3Classes .= ' uk-width-1-' . ($this->field->fieldsPerRowMd) . '@m';
		}
		if ($this->field->fieldsPerRowLg != "1") {
			$this->field->fieldGroupUikit3Classes .= ' uk-width-1-' . ($this->field->fieldsPerRowLg) . '@l';
		}
		if ($this->field->fieldsPerRowXl != "1") {
			$this->field->fieldGroupUikit3Classes .= ' uk-width-1-' . ($this->field->fieldsPerRowXl) . '@xl';
		}
		if (isset($this->field->controlGroupCSSclass)) {
			$this->field->fieldGroupUikit3Classes .= ' ' . trim($this->field->controlGroupCSSclass);
		}
	}
}