<?php
/**
 * Visforms message date class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

namespace  Visolutions\Component\Visforms\Site\Lib\Message;

// no direct access
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Language\Text;

class DateMessage extends Message
{
    protected $text = 'COM_VISFORMS_FIELD_DATE_FORMAT';

	protected function setMessage(): string {
        // if we have a custom php error message, return ''
        // the custom php error message is added in the business/field class only once to each invalid field
        if (!empty($this->customText)) {
            return '';
        }
        else {
            $format = (isset($this->args['format'])) ? $this->args['format'] : '';
            return Text::sprintf($this->text, $this->name, $format);
        }
	}
}