<?php
/**
 * Visforms validate max class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace Visolutions\Component\Visforms\Site\Lib\Validation;

// no direct access
defined('_JEXEC') or die('Restricted access');

class MaxDateValidation extends Validation
{
	protected $date;
	protected $maxDate;

	public function __construct($args) {
        parent::__construct($args);
		$this->date = $this->getTimesstamp($this->args['date'], $this->args['format']);
		$this->maxDate = $this->getTimesstamp($this->args['maxdate'], $this->args['maxdateformat']);
	}

    public function validate(): bool {
		if ($this->date > $this->maxDate) {
			return false;
		} 
		else {
			return true;
		}
	}

	protected function getTimesstamp($date, $format) {
		$unifiedFromattedDate = \DateTime::createFromFormat($format, $date);
		$unifiedFromattedDate->setTimezone(new \DateTimeZone("UTC"));
		$unifiedFromattedDate->setTime(0,0);
		return($unifiedFromattedDate->getTimestamp());
	}
}