<?php
/**
 * Visforms google recaptcha date class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

namespace  Visolutions\Component\Visforms\Site\Recaptcha;

// no direct access
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Language\Text;

class Recaptcha
{
    private string $publicKey;
    private string $privatKey;
    private bool $enabled = false;
    private string $validationUrl = 'https://www.google.com/recaptcha/api/siteverify';
    private string $scriptUrl='https://www.google.com/recaptcha/api.js';
    private string $errorMessage = '';
    private bool $valid = false;
    private int $version;
    private string $dataAttribs = '';

    public function __construct($form) {
        $conficParams = ComponentHelper::getParams('com_visforms');
        // 4: reCaptcha Boxes; 5 reCaptcha invisible
        $this->version = (int) $form->captcha;
        $this->publicKey = $conficParams->get('reCaptchaPublicKey'.$this->version, '');
        $this->privatKey = $conficParams->get('reCaptchaPrivateKey'.$this->version, '');
        if (!empty($this->privatKey) && !empty($this->publicKey)) {
            $this->enabled = true;
        }
        $this->setDataAttribs();
        $this->setScriptUrl();
    }

    public function render() {
        if ($this->enabled) {
            $this->renderScripts();
            return '<div id="dynamic_recaptcha_1" class="g-recaptcha required text-left" data-sitekey="'.$this->publicKey.'"'.$this->dataAttribs.'>';
        }
        return '';
    }

    public function isEnabled() {
        return $this->enabled;
    }

    public function isValid() {
        return $this->valid;
    }

    public function getErrorMessage() {
        return $this->errorMessage;
    }

    // use file_get_contents instead of curl
    public function validate($token) {
        $post_data = http_build_query(
            array(
                'secret' => $this->privatKey,
                'response' => $token,
                'remoteip' => $_SERVER['REMOTE_ADDR']
            )
        );
        $opts = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => 'Content-type: application/x-www-form-urlencoded',
                'content' => $post_data
            )
        );
        $context  = stream_context_create($opts);
        $response = file_get_contents('https://www.google.com/recaptcha/api/siteverify', false, $context);
        if ($response === false || $response === '') {
            $this->errorMessage = Text::_('COM_VISFORMS_PROBLEMS_VALIDATING_CAPTCHA');
        }
        else {
            $response = json_decode($response, true);
            $this->valid = $response['success'];
            if (!$this->valid) {
                $this->errorMessage = Text::_('COM_VISFORMS_CAPTCHA_INVALID');
            }
        }
    }

    // using curl request fails, if website ip is 'suspicious'
    /* public function validate($token) {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->validationUrl,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => array('response' => $token,'secret'=> $this->privatKey, 'sitekey' => $this->publicKey),
        ));

        $response = curl_exec($curl);
        $status = (int) curl_getinfo( $curl, CURLINFO_HTTP_CODE );
        if ($status === 200) {
            curl_close($curl);
            $response = json_decode($response, true);
            $this->valid = $response['success'];
            if (!$this->valid) {
                $this->errorMessage = Text::_('COM_VISFORMS_CAPTCHA_INVALID');
            }
        }
        else {
            $this->errorMessage = Text::_('COM_VISFORMS_PROBLEMS_VALIDATING_CAPTCHA');
        }
    } */

    private function setDataAttribs() {
        if ($this->version === 5) {
            $this->dataAttribs .= ' data-size="invisible"';
            $this->dataAttribs .= ' data-callback="iGRCallback"';
        }
    }

    private function setScriptUrl() {
        if ($this->version === 5) {
            $this->scriptUrl .= '?onload=VfInitIGReCaptcha&render=explicit&hl='. Factory::getApplication()->getLanguage()->getTag();
        }
        else {
            $this->scriptUrl .= '?hl='. Factory::getApplication()->getLanguage()->getTag();
        }
    }

    private function renderScripts() {
        $wa = Factory::getApplication()->getDocument()->getWebAssetManager();
        if ($this->version === 5) {
            $wa->registerAndUseScript('com_visforms.recaptcha.loader', 'com_visforms/grecaptchainvisible.js', [], ['defer' => true, 'async' => true])
                ->registerAndUseScript('com_visforms.recaptcha.api', $this->scriptUrl, [], ['defer' => true, 'async' => true], ['com_visforms.recaptcha.loader']);
        }
        else {
            $wa->registerAndUseScript('com_visforms.recaptcha.api', $this->scriptUrl, [], ['defer' => true, 'async' => true]);
        }
    }
}