<?php
/**
 * Visforms google recaptcha date class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

namespace  Visolutions\Component\Visforms\Site\Timetrap;

// no direct access
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

class Timetrap
{
	private $app;
	private $form;
	private bool $enabled = false;
	private int $timeWindow = 0;
	private bool $valid = false;

	public function __construct($form) {
		$this->app = Factory::getApplication();
		$this->form = $form;
		$this->enabled = (isset($this->form->timewindow) && $this->form->timewindow > 0);
		if ($this->enabled) {
			$this->timeWindow = $this->form->timewindow;
		}
	}

	public function render() {
		if ($this->enabled) {
			return '<input type="hidden" name="' . $this->getParameterName() . '" value="' . time() . '">';
		}
		return '';
	}

	private function getParameterName() {
		$siteName = $this->app->get('sitename');
		$secret = $this->app->get('secret');
		return $this->form->context . md5($siteName . $secret);
	}

	private function getStartValue() {
		return $this->app->getInput()->post->get($this->getParameterName(), '', 'string');
	}

	public function isEnabled() {
		return $this->enabled;
	}

	public function isValid() {
		return $this->valid;
	}

	public function getErrorMessage() {
		return Text::_('COM_VISFORMS_TIMETRAP_VALIDATION_FAILED');
	}

	// use file_get_contents instead of curl
	public function validate() {
		$startValue = $this->getStartValue();
		if ($this->enabled) {
			// invalid start value
			if (!$startValue) {
				$this->valid = false;
				return;
			}
			// too fast
			if ((time() - $startValue) < $this->timeWindow) {
				$this->valid = false;
				return;
			}
		}
		$this->valid = true;
	}
}