<?php

/**
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 1.6
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Extension\Service\Provider\MVCFactory; // for registerServiceProvider
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface; // for $factory
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Database\DatabaseInterface;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use Visolutions\Plugin\Visforms\Visforms\Extension\Visforms;

return new class () implements ServiceProviderInterface {
    public function register(Container $container): void
    {
        // make all Visforms MVC Site Classes available in Plugin
        $container->registerServiceProvider(new MVCFactory('Visolutions\\Component\\Visforms'));
        $container->set(
            PluginInterface::class,
            function (Container $container) {
                $factory      = $container->get(MVCFactoryInterface::class);
                $plugin     = new Visforms(
                    $container->get(DispatcherInterface::class),
                    (array) PluginHelper::getPlugin('visforms', 'visforms')
                );
                $plugin->setMVCFactory($factory); // do we need that? if not, remove use statements in Visforms class
                $plugin->setApplication(Factory::getApplication());
                $plugin->setDatabase($container->get(DatabaseInterface::class));

                return $plugin;
            }
        );
    }
};
