<?php
/**
 * Form component for Joomla
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         http://www.vi-solutions.de 
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

// no direct access
defined('_JEXEC') or die('Restricted access');
include_once __DIR__ .'/include.php';

// Access check: is this user allowed to access the backend of this component?
if (!JFactory::getUser()->authorise('core.manage', 'com_visforms')) {
        return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
}

try {
	JHtml::_('behavior.tabstate');
}
catch (Exception $e) {
	// J4 error handling and message to the user: need to update spambotcheck version
	$text = $e->getMessage();
	$code = $e->getCode();
	$app = \JFactory::getApplication();
	// enqueue the redirect message
	$app->enqueueMessage(\JText::_('COM_VISFORMS_J4_AFTER_UPDATE_MESSAGE'), $app::MSG_ALERT);
	// execute the redirect to extensions update installer
	$app->redirect("index.php?option=com_installer&view=update");
}

// Create the controller
$controller = JControllerLegacy::getInstance('Visforms');
$controller->execute(JFactory::getApplication()->input->get('task'));

// Redirect if set by the controller
$controller->redirect();