<?php
/**
 * Logs model for Spambotcheck
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_spambotcheck
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 4.0
 */
namespace Visolutions\Component\Spambotcheck\Administrator\Model;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\MVC\Model\ListModel;

use Visolutions\Plugin\User\Spambotcheck\Helper\SpambotCheckHelper;

// no direct access
defined('_JEXEC') or die;

class LogsModel extends ListModel {
	public function __construct($config = array(), MVCFactoryInterface $factory = null) {
		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = array(
			'id', 'a.id',
			'action', 'a.action',
			'email', 'a.email',
			'ip', 'a.ip',
			'username', 'a.username',
			'engine', 'a.engine',
			'range', 'a.attempt_date',
			);
		}

		parent::__construct($config, $factory);
	}
	 
	protected function populateState($ordering = null, $direction = null) {
		// todo: change list ordering to SPC table fields (was simply copied from VF)
		$search = $this->getUserStateFromRequest($this->context.'.filter.search', 'filter_search');
		$this->setState('filter.search', $search);

		$action = $this->getUserStateFromRequest($this->context.'.filter.action', 'filter_action', '');
		$this->setState('filter.trust', $action);

		$engine = $this->getUserStateFromRequest($this->context.'.filter.engine', 'filter_engine', '');
		$this->setState('filter.engine', $engine);

		$range = $this->getUserStateFromRequest($this->context.'.filter.range', 'filter_range');
		$this->setState('filter.range', $range);

		// list state information
		parent::populateState('a.id', 'asc');
	}

	protected function getStoreId($id = '') {
		$id	.= ':'.$this->getState('filter.search');
		$id	.= ':'.$this->getState('filter.action');
		$id	.= ':'.$this->getState('filter.engine');
		$id	.= ':'.$this->getState('filter.range');
		return parent::getStoreId($id);
	}

	protected function getListQuery() {
		// create a new query object
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);

		// select the required fields from the table
		$query->select(
			$this->getState(
				'list.select',
				'a.*'
			)
		);
		$tn = "#__spambot_attempts";
		$query->from($db->quoteName($tn) . ' AS a');

		// filter by action
		$action = $this->getState('filter.action');
		if ( !empty($action) && '*' !== $action) {
			$query->where("LCASE(a.action) = '$action'");
		}

		// filter by action
		$engine = $this->getState('filter.engine');
		if ( !empty($engine)) {
			if ('*' === $engine) {
				// commented out and hold for documentation purposes
				// reset entry 'all' to 'make selection' in list box
				//$engine = '';
				//$this->setState('filter.engine', $engine);
				//$app = Factory::getApplication();
				//$app->setUserState($this->context.'.filter.engine', $engine);
			}
			else {
				// there are 'Blacklist-Email' and 'Blacklist-IP' as engines
				// option value in filter select box = 'Blacklist'
				$engine = strtolower($engine);
				$query->where("LCASE(a.engine) LIKE '%$engine%'");
			}
		}

		// filter by search in text fields
		$search = $this->getState('filter.search');
		if (!empty($search)) {
			$search = $db->quote('%'.$db->escape($search, true).'%');
			$query->where('( '.
				$db->qn('a.ip') .' LIKE '. $search .
				' OR ' . $db->qn('a.email') . ' LIKE ' . $search .
				' OR ' . $db->qn('a.username') . ' LIKE '.$search .
				' OR ' . $db->qn('a.request') . ' LIKE ' . $search .
				' OR ' . $db->qn('a.raw_return') . ' LIKE ' . $search .
				' OR ' . $db->qn('a.parsed_return') .' LIKE ' . $search . ')');
		}

		// apply the range filter
		$range = $this->getState('filter.range');
		if ($range != '' && $range != '*') {
			SpambotCheckHelper::addRangeToQuery('a.attempt_date', $range, $db, $query);
		}

		// add the list ordering clause
		$orderCol	= $this->state->get('list.ordering', 'a.id');
		$orderDir	= $this->state->get('list.direction', 'asc');
		$query->order($db->escape($orderCol.' '.$orderDir));
		return $query;
	}
	
	public function delete(&$pks) {
		// initialise variables
		$pks = (array) $pks;
		$table = $this->getTable();

		// iterate the items to delete each one
		foreach ($pks as $i => $pk) {
			if ($table->load($pk)) {
				if (!$table->delete($pk)) {
					$this->setError($table->getError());
					return false;
				}
			}
			else {
				$this->setError($table->getError());
				return false;
			}
		}

		// clear the component's cache
		$this->cleanCache();

		return true;
	}
}
	
