<?php
/**
 * Logs view for Spambotcheck
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_spambotcheck
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 4.0
 */
namespace Visolutions\Component\Spambotcheck\Administrator\View\Logs;

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ContentHelper;
use Joomla\CMS\Toolbar\Button\DropdownButton;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Language\Text;

use Visolutions\Component\Spambotcheck\Administrator\View\HtmlViewBase;

// no direct access
defined('_JEXEC') or die;

class HtmlView extends HtmlViewBase {
	function display($tpl = null) {
		parent::setDataFromModel();
		parent::display($tpl);
	}

	protected function addToolbar() {
		// authorization
		$this->canDo    = ContentHelper::getActions('com_users');
		$user           = Factory::getUser();
		$this->canEdit	= $user->authorise('core.edit','com_spambotcheck');

		// add inline CSS
		$doc = Factory::getDocument();
		$css = '.icon-48-spambotcheck {background:url(../administrator/components/com_spambotcheck/images/logo-banner.png) no-repeat;}';
   		$doc->addStyleDeclaration($css);

		// set title
		ToolbarHelper::title(Text::_( 'COM_SPAMBOTCHECK_LOGS' ), 'spambotcheck' );

		// add action buttons
		$this->addActionButtons_DropDown();

		// add options button
		if (Factory::getUser()->authorise('core.admin', 'com_spambotcheck')) {
			ToolbarHelper::preferences('com_spambotcheck');
		}
	}

	private function addActionButtons_DropDown() {
		// get the toolbar object instance
		/* @var $toolbar Toolbar */
		$toolbar = Toolbar::getInstance('toolbar');

		// add drop-down button for all action entries
		/* @var $dropdown DropdownButton */
		$dropdown = $toolbar->dropdownButton('status-group')
			->text('JTOOLBAR_CHANGE_STATUS')
			->toggleSplit(false)
			->icon('icon-ellipsis-h')
			->buttonClass('btn btn-action')
			->listCheck(true);

		// add authorized action entries
		/* @var $childBar Toolbar */
		$childBar = $dropdown->getChildToolbar();
		// only authorized administrators
		if ($this->canDo->get('core.delete')) {
			$childBar->standardButton('delete')
				->text('COM_SPAMBOTCHECK_DELETE')
				->task('logs.delete')
				->icon('icon-sbc-uncheck')
				->listCheck(true);
		}
	}
}
