<?php
/**
 * Extension entry for Spambotcheck
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_spambotcheck
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 4.0
 */
namespace Visolutions\Component\Spambotcheck\Administrator\Extension;

use Joomla\CMS\Component\Router\RouterServiceInterface;
use Joomla\CMS\Component\Router\RouterServiceTrait;
use Joomla\CMS\Extension\BootableExtensionInterface;
use Joomla\CMS\Extension\MVCComponent;
use Joomla\CMS\HTML\HTMLRegistryAwareTrait;
use Psr\Container\ContainerInterface;
use Visolutions\Component\Spambotcheck\Administrator\Service\HTML\JHTMLSpambotcheck;

// no direct access
defined('_JEXEC') or die( 'Restricted access' );

class SpambotcheckComponent
	extends MVCComponent
	implements BootableExtensionInterface, RouterServiceInterface {
	use RouterServiceTrait;
	use HTMLRegistryAwareTrait;

	/**
	 * Booting the extension. This is the function to set up the environment of the extension like
	 * registering new class loaders, etc.
	 *
	 * If required, some initial set up can be done from services of the container, eg.
	 * registering HTML services.
	 *
	 * @param   ContainerInterface  $container  The container
	 * @return  void
	 * @since   4.0.0
	 */
	public function boot(ContainerInterface $container) {
		$this->getRegistry()->register('spambotcheck', new JHTMLSpambotcheck);
	}
}