<?php
/**
 * Logs view for Spambotcheck
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_spambotcheck
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 4.0
 */
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Layout\LayoutHelper;

// no direct access
defined('_JEXEC') or die;

$listOrder     = $this->escape($this->state->get('list.ordering'));
$listDirection = $this->escape($this->state->get('list.direction'));
?>

<form action="<?php echo Route::_('index.php?option=com_spambotcheck&view=logs');?>" method="post" name="adminForm" id="adminForm"><?php
if (!empty( $this->sidebar)) : ?>
    <div id="j-sidebar-container" class="span2"><?php echo $this->sidebar; ?></div>
    <div id="j-main-container" class="span10"><?php
else : ?>
    <div id="j-main-container"><?php
endif;
    // search tools bar
    echo LayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>
    <div class="clearfix"></div>

	<table class="table table-striped">
	<thead><tr>
        <th width="3%">
            <input type="checkbox" name="toggle" value="" title="<?php echo Text::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
        </th>
        <th width="3%">
            <?php echo HTMLHelper::_('searchtools.sort', 'COM_SPAMBOTCHECK_ID', 'a.id', $listDirection, $listOrder); ?>
        </th>
        <th width="4%">
            <?php echo HTMLHelper::_('searchtools.sort', 'COM_SPAMBOTCHECK_LOGS_ACTION', 'a.action', $listDirection, $listOrder); ?>
        </th>
        <th width="10%">
                <?php echo HTMLHelper::_('searchtools.sort', 'COM_SPAMBOTCHECK_EMAIL', 'a.email', $listDirection, $listOrder); ?>
        </th>
        <th width="6%">
            <?php echo HTMLHelper::_('searchtools.sort', 'COM_SPAMBOTCHECK_IP', 'a.ip', $listDirection, $listOrder); ?>
        </th>
        <th width="8%">
            <?php echo HTMLHelper::_('searchtools.sort', 'COM_SPAMBOTCHECK_USERNAME', 'a.username', $listDirection, $listOrder); ?>
        </th>
        <th width="7%">
            <?php echo HTMLHelper::_('searchtools.sort', 'COM_SPAMBOTCHECK_LOGS_ENGINE', 'a.engine', $listDirection, $listOrder); ?>
        </th>
        <th width="13%">
            <?php echo Text::_( 'COM_SPAMBOTCHECK_LOGS_REQUEST' ); ?>
        </th>
        <th width="25%">
            <?php echo Text::_( 'COM_SPAMBOTCHECK_LOGS_RAW_RETURN' ); ?>
        </th>
        <th width="13%">
            <?php echo Text::_( 'COM_SPAMBOTCHECK_LOGS_PARSED_RETURN' ); ?>
        </th>
        <th width="8%">
            <?php echo HTMLHelper::_('searchtools.sort', 'COM_SPAMBOTCHECK_LOGS_ATTEMPTDATE', 'a.attempt_date', $listDirection, $listOrder); ?>
        </th>
	</tr></thead><?php

	$k = 0;
	$n=count( $this->items );
	for ($i=0; $i < $n; $i++) {
		$item = $this->items[$i];
		$checked 	= HTMLHelper::_('grid.id',   $i, $item->id ); ?>
		<tr class="row<?php echo $i % 2; ?>">
			<td class="center"><?php echo $checked; ?></td>
			<td><?php echo $this->escape($item->id); ?></td>
			<td class="center"><?php echo $this->escape($item->action);?></td>
			<td class="center"><?php echo $this->escape($item->email);?></td>
			<td class="center"><?php echo $this->escape($item->ip); ?></td>
			<td class="center"><?php echo $this->escape($item->username); ?></td>
			<td class="center"><?php echo $this->escape($item->engine); ?></td>
			<td class="center"><?php echo $this->escape($item->request); ?></td>
			<td class="center"><?php echo $this->escape($item->raw_return); ?></td>
			<td class="center"><?php echo $this->escape($item->parsed_return); ?></td>
			<td class="center"><?php echo HTMLHelper::_('date', $item->attempt_date, 'Y-m-d H:i:s'); ?></td>
		</tr><?php
		$k = 1 - $k;
	} ?>

    <tfoot><tr><td colspan="11"><?php echo $this->pagination->getListFooter(); ?></td></tr></tfoot>
	</table>
    <div>
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="boxchecked" value="0" /><?php
        echo HTMLHelper::_('form.token'); ?>
    </div><?php
        HTMLHelper::_('spambotcheck.description', 'logs');
        HTMLHelper::_('spambotcheck.creditsBackend'); ?>
    </div>
</form>