<?php
/** @noinspection FileHeaderInspection */
/** @noinspection MissingSinceTagDocInspection */
/** @noinspection MissingSinceTagDocInspection */

/**
 * Test and debug Helper for Spambotcheck plugin
 *
 * @author		 vi-solutions, Aicha Vack & Ingmar Vack
 * @package		 System SpambotCheckTestHelper - emulate configurable client request IP for testing the plugin SpambotCheck
 * @subpackage   com_spambotcheck
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 4.0
 */

namespace Visolutions\Plugin\System\SpambotcheckTestHelper\Extension;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;
use Joomla\Event\DispatcherInterface;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Event\Application\AfterRouteEvent;

// no direct access
defined('_JEXEC') or die;

class SpambotCheckTestHelper extends CMSPlugin implements SubscriberInterface {
	public function __construct (DispatcherInterface $subject, $config) {
		parent::__construct($subject, $config);
	}

	public static function getSubscribedEvents(): array {
		// return an array of events this subscriber will listen to
		return [
			'onAfterRoute' => 'onAfterRoute',
		];
	}

	public function onAfterRoute(AfterRouteEvent $event) {
		if (Factory::getApplication()->isClient('site')) {
			if ($this->params->get('spbothelper_active', 0) == 1) {
                $ip = $this->params->get('spbothelper_ip', 'stop');
                if('stop' != $ip) {
                    $_SERVER['REMOTE_ADDR'] = $ip;
                }
            }
		}
	}
}