<?php
/**
 * Field - Component Params Description for Spambotcheck
 *
 * @author		 vi-solutions, Aicha Vack & Ingmar Vack
 * @package		 User SpambotCheck - check for possible spambots during register and login
 * @subpackage   Field - Component Params Description
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 4.0
 */
namespace Visolutions\Plugin\User\Spambotcheck\Field;

use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;

// no direct access
defined('_JEXEC') or die;

class ComponentparamdescField extends FormField {
    protected $type = 'componentparamdesc';

	protected function getLabel() {}

    protected function getInput() {
	    return '
		<style>
			div.text, p.text {
				font-weight: normal;
			}
			.regex-sample-ip th, .regex-sample-ip td {
				border-width: 1px;
				padding: 5px 20px;
			}
			span.alert-danger {
				color: red;
			}
		</style>
		<div class="text">' . Text::_('PLG_USER_SPAMBOTCHECK_COMPONENT_OPTIONS_DESC') . '</div>';
    }
}
