<?php
/**
 * Field - Component Params Description for Spambotcheck
 *
 * @author		 vi-solutions, Aicha Vack & Ingmar Vack
 * @package		 User SpambotCheck - check for possible spambots during register and login
 * @subpackage   Field - Component Params Description
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 4.0
 */
namespace Visolutions\Plugin\User\Spambotcheck\Field;

use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;

// no direct access
defined('_JEXEC') or die;

class ComponentregexsamplesemailField extends FormField {
    protected $type = 'componentregexsamplesemail';

	protected function getLabel() {
		return Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_EMAIL_LABEL');
	}

	protected function getInput() {
	    return $this->renderInput();
    }

	private function renderInput() {
		return '
		<div>
		<strong>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_T1') . '</strong>
		<p>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_ATT1') . '</p>
		</div>
		<table class="regex-sample-ip" style="padding: 5px;" xmlns="https://www.w3.org/1999/html">
		<thead><tr><th>E-Mail</th><th>RegEx</th><th>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_RESULT') . '</th><th>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_REMARK') . '</th></tr></thead>
		<tr><td>name@server.de</td><td>name@server\.de</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_ACCEPTED') . '</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_AMBIGUOUS') . '</td></tr>
		<tr><td>my-name@server.demo</td><td>name@server\.de</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_ACCEPTED') . '</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_AMBIGUOUS') . '</td></tr>
		<tr><td>myname@server.demo</td><td>name@server\.de$</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_BLOCKED') . '</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_AMBIGUOUS') . '</td></tr>
		<tr><td>myname@server.demo</td><td>^name@server\.de</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_BLOCKED') . '</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_AMBIGUOUS') . '</td></tr>
		<tr><td>myname@server.demo</td><td>^name@server\.de$</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_BLOCKED') . '</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_UNAMBIGUOUS') . '</td></tr>
		</table>
		<div>
		<br/>
		<strong>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_T2') . '</strong>
		<p>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_ATT2') . '</p>
		</div>
		<table class="regex-sample-ip" style="padding: 5px;" xmlns="https://www.w3.org/1999/html">
		<thead><tr><th>E-Mail</th><th>RegEx</th><th>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_RESULT') . '</th><th>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_REMARK') . '</th></tr></thead>
		<tr><td>name@server.de</td><td>^name@server\.(de|test)$</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_ACCEPTED') . '</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_UNAMBIGUOUS') . '</td></tr>
		<tr><td>name@server.test</td><td>^name@server\.(de|test)$</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_ACCEPTED') . '</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_UNAMBIGUOUS') . '</td></tr>
		<tr><td>name@server.com</td><td>^name@server\.(de|test)$</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_BLOCKED') . '</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_UNAMBIGUOUS') . '</td></tr>
		</table>
		';
	}
}