<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_spambotcheck
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2020 vi-solutions
 */
// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Component\Router\RouterFactoryInterface;
use Joomla\CMS\Dispatcher\ComponentDispatcherFactoryInterface;
use Joomla\CMS\Extension\ComponentInterface;
use Joomla\CMS\Extension\Service\Provider\ComponentDispatcherFactory;
use Joomla\CMS\Extension\Service\Provider\MVCFactory;
use Joomla\CMS\Extension\Service\Provider\RouterFactory;
use Joomla\CMS\HTML\Registry;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Visolutions\Component\Spambotcheck\Administrator\Extension\SpambotcheckComponent;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

return new class implements ServiceProviderInterface {
	/**
	 * Registers the service provider with a DI container.
	 * @param   Container  $container  The DI container.
	 * @return  void
	 * @since   4.0.0
	 */
	public function register(Container $container) {
		$name = '\\Visolutions\\Component\\Spambotcheck';
		$container->registerServiceProvider(new MVCFactory($name));
		$container->registerServiceProvider(new ComponentDispatcherFactory($name));
		//$container->registerServiceProvider(new RouterFactory('\\Visolutions\\Component\\Visforms'));
		$container->registerServiceProvider(new RouterFactory($name));
		$container->set(
			ComponentInterface::class,
			function (Container $container) {
				$component = new SpambotcheckComponent($container->get(ComponentDispatcherFactoryInterface::class));
				$component->setRegistry($container->get(Registry::class));
				$component->setMVCFactory($container->get(MVCFactoryInterface::class));
				$component->setRouterFactory($container->get(RouterFactoryInterface::class));
				return $component;
			}
		);
	}
};