<?php
/**
 * Users controller for Spambotckeck
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_spambotcheck
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 4.0
 */
namespace Visolutions\Component\Spambotcheck\Administrator\Controller;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\Input\Input;
use Joomla\Utilities\ArrayHelper;
use Joomla\Component\Users\Administrator\Model\UserModel;

// no direct access
defined('_JEXEC') or die;

class UsersController extends AdminController {
	function __construct($config = array(), ?MVCFactoryInterface $factory = null, ?CMSApplicationInterface $app = null, ?Input $input = null) {
		parent::__construct($config, $factory, $app, $input);
		$this->registerTask('distrust', 'trust');
		$this->registerTask('block',		'changeBlock');
		$this->registerTask('unblock',		'changeBlock');
	}

	public function getModel($name = 'Users', $prefix = 'Administrator', $config = array('ignore_request' => true)) {
		return parent::getModel($name, $prefix, $config);
	}
	
	public function trust() {
		// check for request forgeries
		$this->checkToken();
		$cid    = $this->input->get('cid', array(), 'array');
		$data   = array('distrust' => 0, 'trust' => 1);
		$task   = $this->getTask();
		$value  = ArrayHelper::getValue($data, $task, 0, 'int');
		
		if (empty($cid)) {
			Factory::getApplication()->enqueueMessage(Text::_($this->text_prefix . '_NO_ITEM_SELECTED'));
        }
        else {
            $model = $this->getModel();
            ArrayHelper::toInteger($cid);

            // toggle suspicious state of items
            if (!$model->trust($cid, $value)) {
	            Factory::getApplication()->enqueueMessage($model->getError());
			}
			else {
				$text = '';
				if ($value == 0) {
                    $text = $this->text_prefix . '_N_ITEMS_SET_TO_DISTRUST';
                }
                elseif ($value == 1) {
                    $text = $this->text_prefix . '_N_ITEMS_SET_TO_TRUST';
                }
				$this->setMessage(Text::plural($text, count($cid)));
			}
		}
		$this->setRedirect(Route::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false));
	}
	
	public function changeBlock() {
		// check for request forgeries
		$this->checkToken();
		$ids	= $this->input->get('cid', array(), 'array');
		$values	= array('block' => 1, 'unblock' => 0);
		$task	= $this->getTask();
		$value	= ArrayHelper::getValue($values, $task, 0, 'int');

		// todo: refactor: remove else part
		if (empty($ids)) {
			Factory::getApplication()->enqueueMessage(Text::_('COM_USERS_USERS_NO_ITEM_SELECTED'));
		}
		else {
			// get the joomla user model
			$model = new UserModel();
			// change the state of the records
			if (!$model->block($ids, $value)) {
				Factory::getApplication()->enqueueMessage($model->getError());
			}
			else {
				if (1 == $value) {
					$this->setMessage(Text::plural('COM_USERS_N_USERS_BLOCKED', count($ids)));
				}
				elseif (0 == $value) {
					$this->setMessage(Text::plural('COM_USERS_N_USERS_UNBLOCKED', count($ids)));
				}
			}
		}

		$this->setRedirect(Route::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false));
	}

	public function activate() {
		// check for request forgeries
		$this->checkToken();
		$ids = $this->input->get('cid', array(), 'array');

		if (empty($ids)) {
			Factory::getApplication()->enqueueMessage(Text::_('COM_USERS_USERS_NO_ITEM_SELECTED'));
		}
		else {
			// get the joomla user model
			$model = new UserModel();
			if (!$model->activate($ids)) {
				Factory::getApplication()->enqueueMessage($model->getError());
			}
			else {
				$this->setMessage(Text::plural('COM_USERS_N_USERS_ACTIVATED', count($ids)));
			}
		}

		$this->setRedirect(Route::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false));
	}
}