<?php
/**
 * JHTMLHelper for Spambotcheck
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_spambotcheck
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 4.0
 */
namespace Visolutions\Component\Spambotcheck\Administrator\Service\HTML;

use Joomla\Filesystem\Path;
use Joomla\CMS\Language\Text;

// no direct access
defined('_JEXEC') or die;

class JHTMLSpambotcheck {
    public static function creditsBackend() { ?>
        <div class="spambotcheckbottom" style="text-align: center;">
            Spambotcheck Version <?php echo JHTMLSpambotcheck::getVersion(); ?>, &copy; <?php echo date("Y"); ?> Copyright by <a href="https://vi-solutions.de" target="_blank" class="smallgrey">vi-solutions</a>, all rights reserved.<br/>
            Spambotcheck is Free Software released under the <a href="https://www.gnu.org/licenses/gpl-2.0.html" target="_blank" class="smallgrey">GNU/GPL License</a>.
        </div> <?php
    }

	public static function getVersion() {
		$xml_file = Path::clean(JPATH_ADMINISTRATOR . '/components/com_spambotcheck/spambotcheck.xml');
		$installed_version = '1.0.0';
		if(file_exists($xml_file)) {
            $xml = simplexml_load_file($xml_file);
            if ($xml !== false) {
                $installed_version = $xml->version;
            }
        }
		return $installed_version;
	}

	public static function description($view) { ?>
		<div class="clearfix"> </div>
		<div>
			<h1><?php echo Text::_('COM_SPAMBOTCHECK_DESCRIPTION'); ?></h1>
			<p><?php echo Text::_('COM_SPAMBOTCHECK_VIEW_' . \Joomla\String\StringHelper::strtoupper($view)  . '_DESCRIPTION'); ?></p>
		</div><?php
	}

	public static function trustStates() {
		return array(
			0	=> array(
				'task'				=> 'trust',
				'text'				=> '',
				'active_title'		=> 'COM_SPAMBOTCHECK_TRUST_DESC',
				'inactive_title'	=> '',
				'tip'				=> true,
				'active_class'		=> 'unpublish',
				'inactive_class'	=> 'unpublish'
			),
			1	=> array(
				'task'				=> 'distrust',
				'text'				=> '',
				'active_title'		=> 'COM_SPAMBOTCHECK_DISTRUST_DESC',
				'inactive_title'	=> '',
				'tip'				=> true,
				'active_class'		=> 'publish',
				'inactive_class'	=> 'publish'
			)
		);
	}

	public static function blockStates( $self = false) {
		if ($self) {
			$states = array(
				1 => array(
					'task'           => 'unblock',
					'text'           => '',
					'active_title'   => 'COM_SPAMBOTCHECK_USER_FIELD_BLOCK_DESC',
					'inactive_title' => '',
					'tip'            => true,
					'active_class'   => 'unpublish',
					'inactive_class' => 'unpublish',
				),
				0 => array(
					'task'           => 'block',
					'text'           => '',
					'active_title'   => '',
					'inactive_title' => 'COM_SPAMBOTCHECK_USERS_ERROR_CANNOT_BLOCK_SELF',
					'tip'            => true,
					'active_class'   => 'publish',
					'inactive_class' => 'publish',
				)
			);
		}
		else {
			$states = array(
				1 => array(
					'task'           => 'unblock',
					'text'           => '',
					'active_title'   => 'COM_SPAMBOTCHECK_TOOLBAR_UNBLOCK',
					'inactive_title' => '',
					'tip'            => true,
					'active_class'   => 'unpublish',
					'inactive_class' => 'unpublish',
				),
				0 => array(
					'task'           => 'block',
					'text'           => '',
					'active_title'   => 'COM_SPAMBOTCHECK_TOOLBAR_BLOCK',
					'inactive_title' => '',
					'tip'            => true,
					'active_class'   => 'publish',
					'inactive_class' => 'publish',
				)
			);
		}

		return $states;
	}

	public static function activateStates() {
		return array(
			1 => array(
				'task'           => 'activate',
				'text'           => '',
				'active_title'   => 'COM_SPAMBOTCHECK_TOOLBAR_ACTIVATE',
				'inactive_title' => '',
				'tip'            => true,
				'active_class'   => 'unpublish',
				'inactive_class' => 'unpublish',
			),
			0 => array(
				'task'           => '',
				'text'           => '',
				'active_title'   => '',
				'inactive_title' => 'COM_SPAMBOTCHECK_ACTIVATED',
				'tip'            => true,
				'active_class'   => 'publish',
				'inactive_class' => 'publish',
			)
		);
	}
}