<?php
/**
 * Users view for Spambotcheck
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_spambotcheck
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 4.0
 */
namespace Visolutions\Component\Spambotcheck\Administrator\View\Help;

use Joomla\CMS\Factory;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Language\Text;

use Visolutions\Component\Spambotcheck\Administrator\View\HtmlViewBase;

// no direct access
defined('_JEXEC') or die;

class HtmlView extends HtmlViewBase {
	protected function addToolbar() {
		// add inline CSS
		$document = Factory::getApplication()->getDocument();
		$css = '.icon-48-visform {background:url(../administrator/components/com_spambotcheck/images/logo-banner.png) no-repeat;}';
		$document->addStyleDeclaration($css);

		// set title
		ToolbarHelper::title(Text::_( 'COM_SPAMBOTCHECK_HELP' ), 'visform' );

		// add options button
		if (Factory::getApplication()->getIdentity()->authorise('core.admin', 'com_spambotcheck')) {
			ToolbarHelper::preferences('com_spambotcheck');
		}
	}
}
