<?php
/**
 * Common base view for Spambotcheck
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_spambotcheck
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 4.0
 */
namespace Visolutions\Component\Spambotcheck\Administrator\View;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\User\User;
use Joomla\Input\Input;

// no direct access
defined('_JEXEC') or die;

class HtmlViewBase extends BaseHtmlView {
	// framework
	protected ?CMSApplicationInterface $app;
	protected $doc;
	protected Input $input;
	protected ?User $user;
	protected $userId;
	// component names
	protected string $baseUrl;
	// payload
	//protected $form; // todo: clarify base class member
	protected $items;
	protected $state;
	protected $sidebar;
	protected $canDo;
	protected $canEdit;
	protected $canDoSpambotcheck;

	public $filterForm;
	public $activeFilters;
	public $pagination;

	function __construct($config = array()) {
		parent::__construct($config);
		// framework
		$this->app          = Factory::getApplication();
		$this->doc          = $this->app->getDocument();
		$this->input        = $this->app->getInput();
		$this->user		    = $this->app->getIdentity();
		$this->userId		= $this->user->id;
		// component names
		// todo: make usage of this class member in template files 'default.php'
		$this->baseUrl      = "index.php?option=com_spambotcheck";
	}


	function display($tpl = null) {
		// we don't need toolbar in the modal window
		if (($this->getLayout() !== 'modal') && ($this->getLayout() !== 'modal_data')) {
			$this->addToolbar();
			// add inline CSS: icons color and sign (font-family: "Font Awesome 5 Free")
			$doc = Factory::getApplication()->getDocument();
			$css  = '.dropdown-divider-sbc {margin: 0.1rem 0;} ';
			$css .= '.icon-sbc-check:before {color: green;content: "\f00c";} ';
			$css .= '.icon-sbc-uncheck:before {color: red; content: "\f00d";} ';
			$css .= '.icon-sbc-activate:before {color: green; content: "\f021";} ';
			$doc->addStyleDeclaration($css);
			$css =
				'.com_spambotcheck.view-users .js-stools-container-filters-visible, ' .
				'.com_spambotcheck.view-logs .js-stools-container-filters-visible, ' .
				// the view parameter is sometimes missing, however
				'.com_spambotcheck.view- .js-stools-container-filters-visible' .
				' { grid-template-columns: repeat(auto-fill, minmax(270px, 1fr)); } ';
			$doc->addStyleDeclaration($css);
		}
		$this->addCommonViewStyleCss();

		parent::display($tpl);
	}

	protected function addToolbar() {}

	protected function setDataFromModel() {
		// get data from the model
		$this->form	         = $this->get('Form');
		$this->items         = $this->get('Items') ?: array();
		$this->state         = $this->get('State');
		$this->filterForm    = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');
		$this->pagination    = $this->get('Pagination');
	}

	private function addCommonViewStyleCss() {
		$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
		$wa->registerAndUseStyle('spambotcheck.admin.spambotcheck',  'administrator/components/com_spambotcheck/css/spambotcheck.css');
		// $css = '';
		// $wa->addInlineStyle($css);
	}
}