<?php
/**
 * Users view for Spambotcheck
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_spambotcheck
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 4.0
 */
namespace Visolutions\Component\Spambotcheck\Administrator\View\Users;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\Helpers\Sidebar;
use Joomla\CMS\Helper\ContentHelper;
use Joomla\CMS\Toolbar\Button\DropdownButton;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;

use Visolutions\Component\Spambotcheck\Administrator\View\HtmlViewBase;
use Visolutions\Component\Spambotcheck\Administrator\Helper\SpambotcheckHelper;

// no direct access
defined('_JEXEC') or die;

class HtmlView extends HtmlViewBase {
	function display($tpl = null) {
		parent::setDataFromModel();
		parent::display($tpl);
	}
	
	protected function addToolbar() {
		// authorization settings
		$this->canDo	         = ContentHelper::getActions('com_users');
		$this->canDoSpambotcheck = SpambotcheckHelper::getActions();

		// add inline CSS
		$doc = Factory::getApplication()->getDocument();
		$css  = '.icon-48-spambotcheck {background:url(../administrator/components/com_spambotcheck/images/logo-banner.png) no-repeat;} ';
		$css .= '.filter-select hr {display:none} ';
   		$doc->addStyleDeclaration($css);

		// set title
		ToolbarHelper::title(Text::_( 'COM_SPAMBOTCHECK_USERS' ), 'spambotcheck');

		// add action buttons
		$this->addActionButtons_DropDown();

		// add options button
		if ($this->canDoSpambotcheck->get('core.admin')) {
			ToolbarHelper::preferences('com_spambotcheck');
		}
	}

	private function addActionButtons_DropDown() {
		// get the toolbar object instance
		/* @var $toolbar Toolbar */
		$toolbar = $this->getDocument()->getToolbar();

		// add drop-down button for all action entries
		/* @var $dropdown DropdownButton */
		$dropdown = $toolbar->dropdownButton('status-group')
			->text('JTOOLBAR_CHANGE_STATUS')
			->toggleSplit(false)
			->icon('icon-ellipsis-h')
			->buttonClass('btn btn-action')
			->listCheck(true);

		// add authorized action entries
		/* @var $childBar Toolbar */
		$childBar = $dropdown->getChildToolbar();
		// only authorized administrators
		if ($this->canDo->get('core.edit.state')) {
			$childBar->standardButton('trust')
				->text('COM_SPAMBOTCHECK_TRUST')
				->task('users.trust')
				->icon('icon-sbc-check')
				->listCheck(true);
			$childBar->standardButton('distrust')
				->text('COM_SPAMBOTCHECK_DISTRUST')
				->task('users.distrust')
				->icon('icon-sbc-uncheck')
				->listCheck(true);
			$childBar->separatorButton()
				->buttonClass('dropdown-divider-sbc');
			$childBar->standardButton('unblock')
				->text('COM_SPAMBOTCHECK_TOOLBAR_UNBLOCK')
				->task('users.unblock')
				->icon('icon-sbc-check')
				->listCheck(true);
			$childBar->standardButton('block')
				->text('COM_SPAMBOTCHECK_TOOLBAR_BLOCK')
				->task('users.block')
				->icon('icon-sbc-uncheck')
				->listCheck(true);
			$childBar->separatorButton()
				->buttonClass('dropdown-divider-sbc');
			$childBar->standardButton('activate')
				->text('COM_SPAMBOTCHECK_TOOLBAR_ACTIVATE')
				->task('users.activate')
				->icon('icon-sbc-activate')
				->listCheck(true);
		}
		// only authorized administrators
		if ($this->canDo->get('core.delete')) {
			$childBar->separatorButton()
				->buttonClass('dropdown-divider-sbc');
			$childBar->standardButton('delete')
				->text('COM_SPAMBOTCHECK_DELETE')
				->task('users.delete')
				->icon('icon-sbc-uncheck')
				->listCheck(true);
		}
	}

	private function addActionButtons_SimpleHorizontalLine() {
		if ($this->canDo->get('core.edit.state')) {
			ToolbarHelper::custom('users.trust', 'publish.png', 'publish.png', 'COM_SPAMBOTCHECK_TRUST', true);
			ToolbarHelper::custom('users.distrust', 'unpublish.png', 'unpublish.png', 'COM_SPAMBOTCHECK_DISTRUST', true);
			ToolbarHelper::publish('users.activate', 'COM_SPAMBOTCHECK_TOOLBAR_ACTIVATE', true);
			ToolbarHelper::unpublish('users.block', 'COM_SPAMBOTCHECK_TOOLBAR_BLOCK', true);
			ToolbarHelper::custom('users.unblock', 'unblock.png', 'unblock_f2.png', 'COM_SPAMBOTCHECK_TOOLBAR_UNBLOCK', true);
		}
		if ($this->canDo->get('core.delete')) {
			ToolbarHelper::deleteList('COM_SPAMBOTCHECK_DELETE', 'users.delete', 'COM_SPAMBOTCHECK_DELETE');
		}
	}

	private function addFilter_j3() {
		Sidebar::setAction('index.php?option=com_spambotcheck&view=users');
		$options = array(
			HTMLHelper::_('select.option', 'today',         Text::_('COM_SPAMBOTCHECK_OPTION_RANGE_TODAY')),
			HTMLHelper::_('select.option', 'past_week',     Text::_('COM_SPAMBOTCHECK_OPTION_RANGE_PAST_WEEK')),
			HTMLHelper::_('select.option', 'past_1month',   Text::_('COM_SPAMBOTCHECK_OPTION_RANGE_PAST_1MONTH')),
			HTMLHelper::_('select.option', 'past_3month',   Text::_('COM_SPAMBOTCHECK_OPTION_RANGE_PAST_3MONTH')),
			HTMLHelper::_('select.option', 'past_6month',   Text::_('COM_SPAMBOTCHECK_OPTION_RANGE_PAST_6MONTH')),
			HTMLHelper::_('select.option', 'past_year',     Text::_('COM_SPAMBOTCHECK_OPTION_RANGE_PAST_YEAR')),
			HTMLHelper::_('select.option', 'post_year',     Text::_('COM_SPAMBOTCHECK_OPTION_RANGE_POST_YEAR')),
			HTMLHelper::_('select.option', '*',             'JALL'),
		);

		Sidebar::addFilter(
			Text::_('COM_SPAMBOTCHECK_SELECT_RANGE'),
			'filter_range',
			HTMLHelper::_('select.options', $options, 'value', 'text', $this->state->get('filter.range'), true)
		);

		$options = array();
		$options[] = HTMLHelper::_('select.option', '0', 'COM_SPAMBOTCHECK_SUSPICIOUS');
		$options[] = HTMLHelper::_('select.option', '1', 'COM_SPAMBOTCHECK_NOT_SUSPICIOUS');
		$options[] = HTMLHelper::_('select.option', '*', 'JALL');

		Sidebar::addFilter(
			Text::_('COM_SPAMBOTCHECK_SELECT_SUSPICION_STATE'),
			'filter_suspicious',
			HTMLHelper::_('select.options', $options, 'value', 'text', $this->state->get('filter.suspicious'), true)
		);

		$options = array();
		$options[] = HTMLHelper::_('select.option', '0', 'COM_SPAMBOTCHECK_NOT_BLOCKED');
		$options[] = HTMLHelper::_('select.option', '1', 'COM_SPAMBOTCHECK_BLOCKED');
		$options[] = HTMLHelper::_('select.option', '*', 'JALL');

		Sidebar::addFilter(
			Text::_('COM_SPAMBOTCHECK_SELECT_BLOCK_STATE'),
			'filter_block',
			HTMLHelper::_('select.options', $options, 'value', 'text', $this->state->get('filter.block'), true)
		);

		$options = array();
		$options[] = HTMLHelper::_('select.option', '1', 'COM_SPAMBOTCHECK_NOT_ACTIVATED');
		$options[] = HTMLHelper::_('select.option', '0', 'COM_SPAMBOTCHECK_ACTIVATED');
		$options[] = HTMLHelper::_('select.option', '*', 'JALL');

		Sidebar::addFilter(
			Text::_('COM_SPAMBOTCHECK_SELECT_ACTIVATION_STATE'),
			'filter_activation',
			HTMLHelper::_('select.options', $options, 'value', 'text', $this->state->get('filter.activation'), true)
		);

		$options = array();
		$options[] = HTMLHelper::_('select.option', '0', 'COM_SPAMBOTCHECK_DISTRUST');
		$options[] = HTMLHelper::_('select.option', '1', 'COM_SPAMBOTCHECK_TRUST');
		$options[] = HTMLHelper::_('select.option', '*', 'JALL');

		Sidebar::addFilter(
			Text::_('COM_SPAMBOTCHECK_SELECT_TRUST_STATE'),
			'filter_trust',
			HTMLHelper::_('select.options', $options, 'value', 'text', $this->state->get('filter.trust'), true)
		);

		$this->sidebar = Sidebar::render();
	}
}
