<?php
/**
 * Spambotcheck view Users
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_spambotcheck
 * @link         http://www.vi-solutions.de 
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2013 vi-solutions
 * @since        Joomla 1.6 
 */

//no direct access
 defined('_JEXEC') or die('Restricted access'); 

$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$canDo 		= UsersHelper::getActions();
$user		= JFactory::getUser();
?>

<form action="<?php echo JRoute::_('index.php?option=com_spambotcheck');?>" method="post" name="adminForm">
<fieldset id="filter-bar">
	<div class="filter-search fltlft">
		<label class="filter-search-lbl" for="filter_search"><?php echo JText::_('JSEARCH_FILTER_LABEL'); ?></label>
		<input type="text" name="filter_search" id="filter_search" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" title="<?php echo JText::_('COM_CONTENT_FILTER_SEARCH_DESC'); ?>" />

		<button type="submit" class="btn"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
		<button type="button" onclick="document.id('filter_search').value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
	</div>
	<div class="filter-select fltrt">
	
		<select name="filter_range" class="inputbox" onchange="this.form.submit()">
			<option value=""><?php echo JText::_('COM_SPAMBOTCHECK_SELECT_RANGE');?></option>
			<?php
			$options = array(
			JHtml::_('select.option', 'today', JText::_('COM_SPAMBOTCHECK_OPTION_RANGE_TODAY')),
			JHtml::_('select.option', 'past_week', JText::_('COM_SPAMBOTCHECK_OPTION_RANGE_PAST_WEEK')),
			JHtml::_('select.option', 'past_1month', JText::_('COM_SPAMBOTCHECK_OPTION_RANGE_PAST_1MONTH')),
			JHtml::_('select.option', 'past_3month', JText::_('COM_SPAMBOTCHECK_OPTION_RANGE_PAST_3MONTH')),
			JHtml::_('select.option', 'past_6month', JText::_('COM_SPAMBOTCHECK_OPTION_RANGE_PAST_6MONTH')),
			JHtml::_('select.option', 'past_year', JText::_('COM_SPAMBOTCHECK_OPTION_RANGE_PAST_YEAR')),
			JHtml::_('select.option', 'post_year', JText::_('COM_SPAMBOTCHECK_OPTION_RANGE_POST_YEAR')),
			);
			$options[] = JHtml::_('select.option', '*', 'JALL');
			?>
			<?php echo JHtml::_('select.options', $options, 'value', 'text', $this->state->get('filter.range'), true);?>
		</select>
	</div>

<div class="filter-select fltrt">
	
<select name="filter_suspicious" class="inputbox" onchange="this.form.submit()">
	<option value=""><?php echo JText::_('COM_SPAMBOTCHECK_SELECT_SUSPICION_STATE');?></option>
	<?php
	$options = array();
	$options[] = JHtml::_('select.option', '0', 'COM_SPAMBOTCHECK_SUSPICIOUS');
	$options[] = JHtml::_('select.option', '1', 'COM_SPAMBOTCHECK_NOT_SUSPICIOUS');
	$options[] = JHtml::_('select.option', '*', 'JALL');
	?>
	<?php echo JHtml::_('select.options', $options, 'value', 'text', $this->state->get('filter.suspicious'), true);?>
</select>
</div>
<div class="filter-select fltrt">
	
<select name="filter_block" class="inputbox" onchange="this.form.submit()">
	<option value=""><?php echo JText::_('COM_SPAMBOTCHECK_SELECT_BLOCK_STATE');?></option>
	<?php
	$options = array();
	$options[] = JHtml::_('select.option', '0', 'COM_SPAMBOTCHECK_NOT_BLOCKED');
	$options[] = JHtml::_('select.option', '1', 'COM_SPAMBOTCHECK_BLOCKED');
	$options[] = JHtml::_('select.option', '*', 'JALL');
	?>
	<?php echo JHtml::_('select.options', $options, 'value', 'text', $this->state->get('filter.block'), true);?>
</select>
</div>
<div class="filter-select fltrt">
	
<select name="filter_activation" class="inputbox" onchange="this.form.submit()">
	<option value=""><?php echo JText::_('COM_SPAMBOTCHECK_SELECT_ACTIVATION_STATE');?></option>
	<?php
	$options = array();
	$options[] = JHtml::_('select.option', '1', 'COM_SPAMBOTCHECK_NOT_ACTIVATED');
	$options[] = JHtml::_('select.option', '0', 'COM_SPAMBOTCHECK_ACTIVATED');
	$options[] = JHtml::_('select.option', '*', 'JALL');
	?>
	<?php echo JHtml::_('select.options', $options, 'value', 'text', $this->state->get('filter.activation'), true);?>
</select>
</div>
<div class="filter-trust fltrt">
<select name="filter_trust" class="inputbox" onchange="this.form.submit()">
	<option value=""><?php echo JText::_('COM_SPAMBOTCHECK_SELECT_TRUST_STATE');?></option>
	<?php
	$options = array();
	$options[] = JHtml::_('select.option', '0', 'COM_SPAMBOTCHECK_DISTRUST');
	$options[] = JHtml::_('select.option', '1', 'COM_SPAMBOTCHECK_TRUST');
	$options[] = JHtml::_('select.option', '*', 'JALL');
	?>
	<?php echo JHtml::_('select.options', $options, 'value', 'text', $this->state->get('filter.trust'), true);?>
</select>

	
</div>	</fieldset>
	<div class="clr"> </div>

	<table class="adminlist">
	<thead>
		<tr>
			<th width="3%">
				<input type="checkbox" name="toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
			</th>	
			<th width="3%">
				<?php echo JHtml::_('grid.sort', 'COM_SPAMBOTCHECK_ID', 'a.id', $listDirn, $listOrder); ?>
			</th>			
			<th width="5%">
				<?php echo JHtml::_('grid.sort', 'COM_SPAMBOTCHECK_USER_ID', 'bid', $listDirn, $listOrder); ?>
			</th>
            <th width="5%">
                <?php echo JHtml::_('grid.sort', 'COM_SPAMBOTCHECK_SUSPICIOUS', 'a.suspicious', $listDirn, $listOrder); ?>	
            </th>
			<th width="4%">
                <?php echo JHtml::_('grid.sort', 'COM_SPAMBOTCHECK_TRUST', 'a.trust', $listDirn, $listOrder); ?>	
            </th>
			<th class="nowrap" width="4%">
				<?php echo JHtml::_('grid.sort', 'COM_SPAMBOTCHECK_HEADING_ENABLED', 'block', $listDirn, $listOrder); ?>
			</th>
			<th class="nowrap" width="4%">
				<?php echo JHtml::_('grid.sort', 'COM_SPAMBOTCHECK_HEADING_ACTIVATED', 'activation', $listDirn, $listOrder); ?>
			</th>
			<th width="6%">
				<?php echo JHtml::_('grid.sort', 'COM_SPAMBOTCHECK_IP', 'a.ip', $listDirn, $listOrder); ?>
			</th>
			<th width="6%">
				<?php echo JHtml::_('grid.sort', 'COM_SPAMBOTCHECK_NAME', 'name', $listDirn, $listOrder); ?>
			</th>
			<th width="6%">
				<?php echo JHtml::_('grid.sort', 'COM_SPAMBOTCHECK_USERNAME', 'username', $listDirn, $listOrder); ?>
			</th>
			<th width="6%">
				<?php echo JHtml::_('grid.sort', 'COM_SPAMBOTCHECK_USER_GROUP_NAME', 'groupname', $listDirn, $listOrder); ?>
			</th>
			<th width="12%">
					<?php echo JHtml::_('grid.sort', 'COM_SPAMBOTCHECK_EMAIL', 'email', $listDirn, $listOrder); ?>
			</th>
			<th width="10%">
				<?php echo JHtml::_('grid.sort', 'COM_SPAMBOTCHECK_REGISTERDATE', 'registerdate', $listDirn, $listOrder); ?>
			</th>
			<th width="23%">
				<?php echo JText::_( 'COM_SPAMBOTCHECK_NOTE' ); ?>
			</th>
			<th width="3%">
				<?php echo JHtml::_('grid.sort', 'COM_SPAMBOTCHECK_HITS', 'a.hits', $listDirn, $listOrder); ?>
			</th>
			

		</tr>			
	</thead>
	<?php
	$k = 0;
	$n=count( $this->items );
	for ($i=0; $i < $n; $i++)
	{
		$item = $this->items[$i];
		$checked 	= JHTML::_('grid.id',   $i, $item->user_id );
		$canChange	= $user->authorise('core.edit.state',	'com_users');
		// If this group is super admin and this user is not super admin, $canChange is false
		if ((!$user->authorise('core.admin')) && JAccess::check($item->user_id, 'core.admin', 'com_users')) {
			$canChange	= false;
		}
		$supicious = !$item->suspicious ? JHtml::_('image', '/administrator/components/com_spambotcheck/images/suspicious_16.png', JText::_('JYES')) : ''; 
		
	?>
			<td class="center">
				<?php echo $checked; ?>
			</td>
			<td>
				<?php echo $this->escape($item->id); ?>
			</td>
			<td class="center">
				<?php echo $this->escape($item->user_id); ?>
			</td>
			<td class="center">
                <?php echo $supicious;?>
            </td>
			<td class="center">
				<?php if ($canChange) : ?>
					<?php echo JHtml::_('grid.boolean', $i, $item->trust, 'users.trust', 'users.distrust');?>
				<?php else : ?>
					<?php echo JText::_($item->trust ? 'JYES' : 'JNO'); ?>
				<?php endif; ?>
            </td>
			<td class="center">
				<?php if ($canChange) : ?>
					<?php if ($user->id != $item->user_id) : ?>
						<?php echo JHtml::_('grid.boolean', $i, !$item->block, 'users.unblock', 'users.block'); ?>
					<?php else : ?>
						<?php echo JHtml::_('grid.boolean', $i, !$item->block, 'users.block', null); ?>
					<?php endif; ?>
				<?php else : ?>
					<?php echo JText::_($item->block ? 'JNO' : 'JYES'); ?>
				<?php endif; ?>
			</td>
			<td class="center">
				<?php if ($canChange) : ?>
					<?php echo JHtml::_('grid.boolean', $i, !$item->activation, 'users.activate', null); ?>
				<?php else : ?>
					<?php echo JText::_($item->activation ? 'JYES' : 'JNO'); ?>
				<?php endif; ?>
			</td>
			<td class="center">
                <?php echo $this->escape($item->ip);?>
            </td>
            
			<td class="center">
				<?php echo $this->escape($item->name); ?>
			</td>
			<td class="center">
				<?php echo $this->escape($item->username); ?>
			</td>
			<td class="center">
				<?php echo $item->group_names; ?>
			</td>
			<td class="center">
				<?php echo $this->escape($item->email); ?>
			</td>
			<td class="center">
	
				<?php echo JHtml::_('date', $item->registerdate, 'Y-m-d H:i:s'); ?>
			</td>
			<td class="center">
				<?php echo $this->escape($item->note); ?>
			</td>		
           	<td class="center">
				<?php echo $item->hits; ?>
			</td>
		</tr>
		<?php
		$k = 1 - $k;
	}
	?>
    
    
    <tfoot>
    <tr>
      <td colspan="15"><?php echo $this->pagination->getListFooter(); ?></td>
    </tr>
  	</tfoot>
    
	</table>
<div>
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
	<?php echo JHtml::_('form.token'); ?>
</div>
</form>
<?php JHTML::_('spambotcheck.description', 'users'); ?>

 <?php JHTML::_('spambotcheck.creditsBackend'); ?>