<?php
/**
 * Users view for Spambotcheck
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_spambotcheck
 * @link         http://www.vi-solutions.de 
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2013 vi-solutions
 * @since        Joomla 1.6 
 */

// no direct access
defined('_JEXEC') or die( 'Restricted access' );

jimport( 'joomla.application.component.view' );

/**
 * visforms View
 *
 * @package    Joomla.Administratoar
 * @subpackage com_spambotcheck
 * @since      Joomla 1.6
 */
class SpambotcheckViewUsers extends JView
{
	protected $form;
	protected $items;
	protected $state;
	protected $canDo;
	
	/**
	 * visforms view display method
	 * @return void
	 **/
	function display($tpl = null)
	{
		
		// Get data from the model
		$this->form	= $this->get('Form');
		$this->items = $this->get('Items');
		$this->state = $this->get('State');
		
		//$items = $this->get( 'Data');
		$pagination = $this->get('Pagination');

		$this->assignRef('pagination', $pagination);
		
		// We don't need toolbar in the modal window.
		if (($this->getLayout() !== 'modal') && ($this->getLayout() !== 'modal_data')) {
			$this->addToolbar();
		}
		
		parent::display($tpl);
	}
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		$canDo	= UsersHelper::getActions();
		$canDoSpambotcheck = SpambotcheckHelper::getActions();
		$doc = JFactory::getDocument();
		$css = '.icon-48-spambotcheck {background:url(../administrator/components/com_spambotcheck/images/logo-banner.png) no-repeat;} ';
   		$doc->addStyleDeclaration($css);		

		JToolBarHelper::title(JText::_( 'COM_SPAMBOTCHECK_USERS' ), 'spambotcheck' );
		if ($canDo->get('core.edit.state')) {
			JToolBarHelper::custom('users.trust', 'publish.png', 'publish.png', 'COM_SPAMBOTCHECK_TRUST', true);
			JToolBarHelper::custom('users.distrust', 'unpublish.png', 'unpublish.png', 'COM_SPAMBOTCHECK_DISTRUST', true);
			JToolBarHelper::divider();
			JToolBarHelper::publish('users.activate', 'COM_SPAMBOTCHECK_TOOLBAR_ACTIVATE', true);
			JToolBarHelper::divider();
			JToolBarHelper::unpublish('users.block', 'COM_SPAMBOTCHECK_TOOLBAR_BLOCK', true);
			JToolBarHelper::custom('users.unblock', 'unblock.png', 'unblock_f2.png', 'COM_SPAMBOTCHECK_TOOLBAR_UNBLOCK', true);
			JToolBarHelper::divider();

		}
		if ($canDo->get('core.delete')) {
			JToolBarHelper::deleteList('COM_SPAMBOTCHECK_DELETE', 'users.delete', 'COM_SPAMBOTCHECK_DELETE');
		}
		
		if ($canDoSpambotcheck->get('core.admin')) {
			JToolBarHelper::divider();
			JToolBarHelper::preferences('com_spambotcheck');
			JToolBarHelper::divider();
		}

	}
}
