<?php
/**
 * JHTMLHelper for Spambotcheck
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_spambotcheck
 * @link         http://www.vi-solutions.de 
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

/**
 * Utility class for creating HTML Grids
 *
 * @static
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @since   1.5.5
 */
class JHTMLSpambotcheck
{

  /**
   * Displays the credits
   *
   * @return  void
   * @since   1.5.5
   */
  public static function creditsBackend()
  {
    
	?>
		<div class="spambotcheckbottom" style="text-align: center;">
			Spambotcheck Version <?php echo JHTMLSpambotcheck::getVersion(); ?>, &copy; 2013 Copyright by <a href="http://vi-solutions.de" target="_blank" class="smallgrey">vi-solutions</a>, all rights reserved. 
			Spambotcheck is Free Software released under the <a href="http://www.gnu.org/licenses/gpl-2.0.html"target="_blank" class="smallgrey">GNU/GPL License</a>. 
		</div>
	<?php
	}

	public static function getVersion() {
		$xml_file = JPath::clean(JPATH_COMPONENT_ADMINISTRATOR . DS . 'spambotcheck.xml');
		$installed_version = '1.0.0';
		if(file_exists($xml_file))
			{
				$xml = JFactory::getXMLParser('simple');
				$xml->loadFile($xml_file);

				$version_tag = $xml->document->getElementByPath('version');
				$installed_version = $version_tag->data();
			}
		return $installed_version;
	}
	
	public static function description($view)
	{
		?>
		<div style="padding: 20px 0;">
			<h1>
			<?php echo JText::_('COM_SPAMBOTCHECK_DESCRIPTION'); ?>
			</h1>
			<p style="font-size: 1.2em">
			<?php echo JText::_('COM_SPAMBOTCHECK_VIEW_' . JString::strtoupper($view)  . '_DESCRIPTION'); ?>
			</p>
		</div>
		<?php
	}
}
?>