<?php

/**
 * @version		$Id: script.php 22354 2011-11-07 05:01:16Z github_bot $
 * @package		com_visforms
 * @subpackage	plg_visforms_spamcheck
 * @copyright	Copyright (C) 2005 - 2011 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;


class plguserspambotcheckInstallerScript
{
	/**
	 * Constructor
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 */
   // public function __constructor(JAdapterInstance $adapter);

	/**
	 * Called before any type of action
	 *
	 * @param   string  $route  Which action is happening (install|uninstall|discover_install)
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function preflight($route, JAdapterInstance $adapter) {
		$jversion = new JVersion();

		// Installing component manifest file version
		$this->release = $adapter->get( "manifest" )->version;
	
		// Manifest file minimum Joomla version
		$this->minimum_joomla_release = $adapter->get( "manifest" )->attributes()->version;   

		// abort if the current Joomla release is older
		if( version_compare( $jversion->getShortVersion(), $this->minimum_joomla_release, 'lt' ) ) {
			Jerror::raiseWarning(null, JText::_('PLG_USER_SPAMBOTCHECK_WRONG_JOOMLA_VERSION') .$this->minimum_joomla_release);
			return false;
		}

		// abort if the component being installed is not newer than the currently installed version
		if ( $route == 'update' ) {
			$oldRelease = $this->getParam('version');
			$rel = $oldRelease . JText::_('PLG_USER_SPAMBOTCHECK_TO') . $this->release;
			if ( version_compare( $this->release, $oldRelease, 'le' ) ) {
				Jerror::raiseWarning(null, JText::_('PLG_USER_SPAMBOTCHECK_WRONG_VERSION') . $rel);
				return false;
			}
		}
		else 
		{ 
			$rel = $this->release; 
		}
		
		if ($route == 'update') {
			echo '<p>' . JText::_('PLG_USER_SPAMBOTCHECK_UPDATE_VERSION') . $rel . '</p>';
		}
		else if ($route == 'install') {
			echo '<p>' . JText::_('PLG_USER_SPAMBOTCHECK_INSTALL_VERSION') . $rel . '</p>';
		}
	}

	/**
	 * Called after any type of action
	 *
	 * @param   string  $route  Which action is happening (install|uninstall|discover_install)
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
    //public function postflight($route, JAdapterInstance $adapter);
	 public function postflight($route, JAdapterInstance $adapter){
		//Install Component
		$status = new stdClass;
        $status->components = array();
		$src = $adapter->getParent()->getPath('source');
		$manifest = $adapter->getParent()->manifest;
        $components = $manifest->xpath('components/component');
		
		foreach ($components as $component)
        {
            $name = (string)$component->attributes()->component;
            //check if component is allready installed
			$db = JFactory::getDBO();
            $query = "SELECT `extension_id` FROM `#__extensions` WHERE `type`='component' AND element = ".$db->Quote($name)."";
            $db->setQuery($query);
            $extensions = $db->loadColumn();
  
            $path = $src.'/components/'.$name;
            $installer = new JInstaller;
			if (count($extensions))
			{
				$result = $installer->update($path);
			}
			else
			{
				$result = $installer->install($path);
				//we assume that autoupdater installed version 1.1.11 and 1.1.12 together. Postflight is only performed once (this one) so we have to make sure, that plugin is enabled (which should be done by postflight of 1.1.11).
				//enable plugin
				$db = JFactory::getDbo();
				$query = "UPDATE #__extensions SET enabled=1 WHERE type='plugin' AND element=".$db->Quote('spambotcheck')." AND folder=".$db->Quote('user');
				$db->setQuery($query);
				$db->query();
			}
			$message = JText::_('COM_SPAMBOTCHECK_DESC');
            $status->components[] = array('name' => $name, 'result' => $result, 'message' => $message);
			$this->installationResults($status);
        }		
	}

	/**
	 * Called on installation
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function install(JAdapterInstance $adapter) {
		
		//Give a warning if cURL is not enabled on system; plugin will not be able to identify spammer
		$extension = 'curl';
		if (!extension_loaded($extension)) {
			JFactory::getApplication()->enqueueMessage(JText::_('PLG_USER_SPAMBOTCHECK_CURL_MISSING'), 'warning');
		}
	}

	/**
	 * Called on update
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	//public function update(JAdapterInstance $adapter);

	/**
	 * Called on uninstallation
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 */
	public function uninstall(JAdapterInstance $adapter)
	{
		$status = new StdClass;
		$status->components = array();
		$db	= JFactory::getDBO();
		$app = JFactory::getApplication();

		if ($db) 
		{
			$db->setQuery("drop table if exists #__spambot_attempts");
			$db->query();			
		}
	
		$manifest = $adapter->getParent()->manifest;
		$components = $manifest->xpath('components/component');
		foreach ($components as $component)
        {
            $name = (string)$component->attributes()->component;
            $db = JFactory::getDBO();
            $query = "SELECT `extension_id` FROM `#__extensions` WHERE `type`='component' AND element = ".$db->Quote($name)."";
            $db->setQuery($query);
            $extensions = $db->loadColumn();
            if (count($extensions))
            {
                foreach ($extensions as $id)
                {
                    $installer = new JInstaller;
                    $result = $installer->uninstall('component', $id);
                }
                $status->components[] = array('name' => $name, 'result' => $result);
            }
            
        }
        $this->uninstallationResults($status);
	}
		
	/*
	 * get a variable from the manifest file (actually, from the manifest cache).
	 */
	function getParam( $name ) {
		$db = JFactory::getDbo();
		$db->setQuery('SELECT manifest_cache FROM #__extensions WHERE name = "User - SpambotCheck"');
		$manifest = json_decode( $db->loadResult(), true );
		return $manifest[ $name ];
	}
 
	/*
	 * sets parameter values in the component's row of the extension table
	 */
	function setParams($param_array) {
		if ( count($param_array) > 0 ) {
			// read the existing component value(s)
			$db = JFactory::getDbo();
			$db->setQuery('SELECT params FROM #__extensions WHERE name = "User - SpambotCheck"');
			$params = json_decode( $db->loadResult(), true );
			// add the new variable(s) to the existing one(s)
			foreach ( $param_array as $name => $value ) {
				$params[ (string) $name ] = (string) $value;
			}
			// store the combined new and existing values back as a JSON string
			$paramsString = json_encode( $params );
			$db->setQuery('UPDATE #__extensions SET params = ' .
				$db->quote( $paramsString ) .
				' WHERE name = "User - SpambotCheck"' );
				$db->query();
		}
	}
	
	private function installationResults($status)
    {
        $language = JFactory::getLanguage();
        $language->load('plg_spambotcheck');
        $rows = 0; ?>
		<?php echo JText::_('PLG_USER_SPAMBOTCHECK_INSTALL_MESSAGE'); ?>
        <img src="<?php echo JURI::base(); ?>/components/com_spambotcheck/images/logo-banner.png" alt="" align="right" />
        <h2><?php echo JText::_('PLG_USER_SPAMBOTCHECK_INSTALLATION_STATUS'); ?></h2>
        <table class="adminlist table table-striped">
            <thead>
                <tr>
                    <th class="title" style="text-align: left;"><?php echo JText::_('PLG_USER_SPAMBOTCHECK_EXTENSION'); ?></th>
                    <th width="30%" style="text-align: left;"><?php echo JText::_('PLG_USER_SPAMBOTCHECK_STATUS'); ?></th>
                </tr>
            </thead>
            <tbody>
                <tr class="row0">
                    <td class="key"><?php echo JText::_('PLG_USER_SPAMBOTCHECK_PLUGIN'); ?></td>
                    <td><strong><?php echo JText::_('PLG_USER_SPAMBOTCHECK_INSTALLED'); ?></strong>
					<p><?php echo JText::_('PLG_USER_SPAMBOTCHECK_UPDATE_NEW_FEATURE'); ?></p>
					</td>
                </tr>
                <?php if (count($status->components)): ?>
                <tr>
                    <th><?php echo JText::_('PLG_USER_SPAMBOTCHECK_COMPONENT'); ?></th>
                    <th></th>
                </tr>
                <?php foreach ($status->components as $component): 
				isset ($component['message']) && $component['message'] != "" ? $message = ' - ' . $component['message'] : $message = "";
				?>
                <tr class="row<?php echo(++$rows % 2); ?>">
                    <td class="key"><?php echo $component['name']; ?></td>
                    <td><?php echo ($component['result']) ? '<strong>' . JText::_('PLG_USER_SPAMBOTCHECK_INSTALLED') . $message : '<strong style="color: red">' . JText::_('PLG_USER_SPAMBOTCHECK_NOT_INSTALLED'); ?></strong></td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    <?php
    }
	
	private function uninstallationResults($status)
    {
		$language = JFactory::getLanguage();
		$language->load('plg_spambotcheck');
		$rows = 0;
	 ?>
        <h2><?php echo JText::_('PLG_USER_SPAMBOTCHECK_REMOVAL_STATUS'); ?></h2>
        <table class="adminlist table table-striped">
            <thead>
                <tr>
                    <th class="title" style="text-align: left;"><?php echo JText::_('PLG_USER_SPAMBOTCHECK_EXTENSION'); ?></th>
                    <th width="30%" style="text-align: left;"><?php echo JText::_('PLG_USER_SPAMBOTCHECK_STATUS'); ?></th>
                </tr>
            </thead>
            <tbody>
                <tr class="row0">
                    <td class="key"><?php echo JText::_('PLG_USER_SPAMBOTCHECK_PLUGIN'); ?></td>
                    <td><strong><?php echo JText::_('PLG_USER_SPAMBOTCHECK_REMOVED'); ?></strong></td>
                </tr>
                <?php if (count($status->components)): ?>
                <tr>
                    <th><?php echo JText::_('PLG_USER_SPAMBOTCHECK_COMPONENT'); ?></th>
                    <th></th>
                </tr>
                <?php foreach ($status->components as $component): ?>
                <tr class="row<?php echo(++$rows % 2); ?>">
                    <td class="key"><?php echo $component['name']; ?></td>
                    <td><?php echo ($component['result']) ? '<strong>' . JText::_('PLG_USER_SPAMBOTCHECK_REMOVED') : '<strong style="color: red">' . JText::_('PLG_USER_SPAMBOTCHECK_NOT_REMOVED'); ?></strong></td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    <?php
    }
}

?>
