<?php
// **************************************************************
// File: SpambotCheckHelpers.php
// Purpose: Contains functions used by SpambotCheckImpl.
// Author: MysteryFCM, modified by Robert Kuster.  
// The implementation is heavily based on MysteryFCMs "check_spammers.zip"
// from: http://temerc.com/forums/viewtopic.php?f=71&t=6103&start=0
// I simplified the code, cleaned it up, ported parts of it to 
// Joomla!, and fixed quite some bugs in it. 
// **************************************************************

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

// Determine whether curl is available or not

function isCUrlAvailable() {
	$extension = 'curl';
	if (extension_loaded($extension)) {
		return true;
	}
	else {
		return false;
	}
}

// Determine if a URL is online or not

function isURLOnline($sSiteToCheck) {
	// check, if curl is available
	if (isCUrlAvailable()) {
		// check if url is online
		$curl = @curl_init($sSiteToCheck);
		curl_setopt($curl, CURLOPT_TIMEOUT, 10);
		curl_setopt($curl, CURLOPT_FAILONERROR, 1);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		@curl_exec($curl);
		if (curl_errno($curl) != 0) {
			return false;
		}
		else {
				return true;
			}
		curl_close($curl);
	}
	else {
		//curl is not loaded, this won't work
		return false;
	}
}


// Gets a URL's content
//
//	If file_get_contents() is available, use that, otherwise use cURL
//
function getURL($sURL)
{
	if(isURLOnline($sURL) == false)
	{
		$sURLTemp = 'Unable to connect to server';
		return $sURLTemp;
	}
	else
	{
		if(function_exists('file_get_contents') && ini_get('allow_url_fopen') == true)
		{
			// Use file_get_contents
			$sURLTemp = @file_get_contents($sURL);
		}
		else
		{
			// Use cURL (if available)
			if (isCUrlAvailable()) {
				$curl = @curl_init();
				curl_setopt($curl, CURLOPT_URL, $sURL);
				curl_setopt($curl, CURLOPT_VERBOSE, 1);
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($curl, CURLOPT_HEADER, 0);
				$sURLTemp = @curl_exec($curl);
				curl_close($curl);
			}
			else {
				$sURLTemp = 'Unable to connect to server';
				return $sURLTemp;
			}
		}
		return $sURLTemp;
	}
	//echo 'DEBUG: $sURLTemp: '.$sURLTemp.'<br/>';
}


// Determines if e-mail is valid
//
// Thanks to ILoveJackDaniel's at:
// http://www.linuxjournal.com/article/9585
//

// AVack:: 20120330 Joomla! allready checks validity of e-mails on login and on registration

// Determines if passed IP is valid
//
//	Thanks to Mike @ BotScout (botscout.com) for this function
//	http://botscout.com/forum/index.php/topic,2.msg128.html#msg128
//
function IsvalidIP($ip){
	if(preg_match("'\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\b'", $ip)){
		return true;
	}else{
		return false;
	}
}


// Log spammer to database (if enabled)
//
// Usage example:
// ---------------
// LogSpammerToDB('test@test.com', '12.12.12.12', 'username', 'ProjectHoneyPot', '127.41.11.5', 'ThreatScore=11, DaysSinceLastActivity=41', $plgParams)
//
function LogSpammerToDB($sEmail, $sIP, $sUsername, $sEngine, $sRequest, $sRawReturn, $sParsedReturn, &$plgParams )
{
	if (!$plgParams->get('spbot_log_to_db', 0))	{
		// -> save spambots to DB?
		return false;
	}
	
	CreateSpambotTableIfNotExist();	

	// Change empty vars to "NULL"
	if($sEmail==''){$sEmail='NULL';}
	if($sIP==''){$sIP='NULL';}
	if($sUsername==''){$sUsername='NULL';}

	// Trim anything that could screw up SQL
	$sEmail = str_replace(array("0x", ",", "%", "'","\r\n", "\r", "\n"), "", $sEmail);
	//$sEmail = mysql_real_escape_string($sEmail);
	
	$sIP = str_replace(array("0x", ",", "%", "'","\r\n", "\r", "\n"), "", $sIP);
	//$sIP = mysql_real_escape_string($sIP);
	
	$sUsername = str_replace(array("0x", ",", "%", "'","\r\n", "\r", "\n"), "", $sUsername);
	//$sUsername = mysql_real_escape_string($sUsername);
		
	// add DB record
	$db = &JFactory::getDBO();	
	$sDate = gmdate("Y-m-d H:i:s", time());
	$sAction = $plgParams->get('current_action', '-');
	$strSQL = "INSERT INTO #__spambot_attempts (action, email, ip, username, engine, request, raw_return, parsed_return, attempt_date) "
					. "VALUES({$db->quote($sAction)}, {$db->quote($sEmail)}, {$db->quote($sIP)}, {$db->quote($sUsername)}, {$db->quote($sEngine)}, "
					.       " {$db->quote($sRequest)}, {$db->quote($sRawReturn)}, {$db->quote($sParsedReturn)}, {$db->quote($sDate)})";
	$db->setQuery($strSQL);
	$db->query();
	return true;
}

function CreateSpambotTableIfNotExist()
{
	static $alreadyCalled = 0;		
	if ($alreadyCalled == 0)
	{
		// We werent yet called in this seasson.
		// Let's do the check if our table exists now.		
		$alreadyCalled = 1;
		
		$db = &JFactory::getDBO();
		$db->setQuery("SELECT TOP 1 * FROM #__spambot_attempts");
		$result = $db->loadObjectList();

		if (!isset($result))
		{	// Table doens't exist yet. Let's create it.
			$strSQL = "CREATE TABLE IF NOT EXISTS #__spambot_attempts
			(
				id int NOT NULL AUTO_INCREMENT,
				PRIMARY KEY(id),
				action varchar(255),
				email varchar(255),
				ip varchar(15),
				username varchar(255),
				engine varchar(255),
				request varchar(255),
				raw_return varchar(255),
				parsed_return varchar(255),
				attempt_date DATETIME
			) ENGINE=MyISAM DEFAULT CHARSET=utf8";
			$db->Execute($strSQL);
		}
	}
}

?>