<?php
/**
* @version		$Id: plgUserSpamCheck.php
* @package		User SpamCheck - check for possible spambots during register and login
* @author		vi-solutions, Robert Kuster
* @copyright	Copyright (C) 2010 vi-solutions. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );
jimport('joomla.plugin.plugin');
require_once(JPATH_SITE.DS.'plugins'.DS.'user'.DS.'SpambotCheck'.DS.'SpambotCheckImpl.php');


class plgUserSpambotCheck extends JPlugin
{
	function plgUserSpambotCheck(& $subject, $config) {
		parent::__construct($subject, $config);
		
		//load the translation
		$this->loadLanguage( 'plg_user_spambotcheck', JPATH_SITE .DS .'administrator' );
	}
	
	
	/**
	 * Example store user method
	 *
	 * Method is called before user data is stored in the database
	 *
	 * @param 	array		holds the old user data (without new changes applied)
	 * @param 	boolean		true if a new user is stored
	 * 
	 * RKFIX - Check if this is a known spammer. If so:
	 * 			> prevent user registration
	 *			> notify the admins about the registration attempt via email
	 *			> show the the normal login notification to the user 
	 */
	function onBeforeStoreUser($userOld, $isnew)
	{	
		$user = array( 
			"fullname" => JRequest::getVar('name', ''),
			"username" => JRequest::getVar('username', ''),
			"email" => JRequest::getVar('email', '')
		 );
		
		$this->params->set('current_action', 'Register');
		$spamString = "";
		if($isnew && plgUserSpambotCheck::_isSpammer($user, $spamString))
		{
			//------------------------------------------------
			// send email notification to all sys-admins
			plgUserSpambotCheck::_sendMailToAdmin($user, $spamString, JText::_( 'EMAIL_SUBJECT_REGISTER_PREVENTION_TXT' ));			
			$usersConfig = &JComponentHelper::getParams( 'com_users' );
			// redirect index.php and display an error notificaton to the user
			$message  = JText::_( 'USER_REGISTRATION_SPAM_TXT' );
			
			global $mainframe;
			$mainframe->redirect('index.php', $message, "error");
			$mainframe->close();
			return false;			
		}
		return true;
	}
	
	
	/**
	 * This method should handle any login logic and report back to the subject
	 *
	 * @access	public
	 * @param   array   holds the user data
	 * @param 	array   array holding options (remember, autoregister, group)
	 * @return	boolean	True on success
	 * @since	1.5
	 * 
	 * RKFIX - Check if this is a known spammer. If so:
	 * 			> prevent a login
	 *			> notify the admins about the login attempt via email 
	 *			> show an error message to the user
	 */
	function onLoginUser($user, $options = array())
	{
		if (!$this->params->get('spbot_monitor_events', 1))	{
			// -> dont monitor log-ins 
			return true;
		}
		
		$this->params->set('current_action', 'Login');
		$spamString = "";
		if (plgUserSpambotCheck::_isSpammer($user, $spamString))
		{
			//------------------------------------------------
			// Undo task done in plgUserJoomla::onLoginUser
			// (in essence we are forcing a logout operation done by plgUserJoomla here)
			
			// -> store a guest-JUser to the session		 
			$instance = new JUser();	// createsa guest user	
			$instance->set( 'id'			, 0 );
			$instance->set( 'name'			, '' );
			$instance->set( 'username'		, '' );
			$instance->set( 'gid'			, 0);
			$instance->set( 'usertype'		, '');
					
			$session =& JFactory::getSession();
			$session->set('user', $instance);	

			// -> store a guest-JUser to the #__session table
			$table = & JTable::getInstance('session');	// Get the session-table object
			$table->load( $session->getId() );	

			$table->guest 		= $instance->get('guest');
			$table->username 	= $instance->get('username');
			$table->userid 		= intval($instance->get('id'));
			$table->usertype 	= $instance->get('usertype');
			$table->gid 		= intval($instance->get('gid'));
			$table->update();
			
			//------------------------------------------------
			// send email notification to all sys-admins
			plgUserSpambotCheck::_sendMailToAdmin($user, $spamString, JText::_( 'EMAIL_SUBJECT_LOGIN_PREVENTION_TXT' ));
			
			//------------------------------------------------
			// redirect us to the old page and display an error notificaton to the user
			global $mainframe;
			$mainframe->redirect(JRoute::_($options['return']), sprintf (JText::_('USER_LOGIN_SPAM_TXT')), "error");
			$mainframe->close();
			return false;
		}
		
		return true;
	}
	
	
	/**
	 * Method check if the user specified is a spammer.
	 *
	 * @param 	array		holds the user data
	 * @param 	string		hold the raw string returned by "check_spammers_plain.php" 
	 * 
	 * @return boolean True if user is a spammer and False if he isn't. 
	 */
	function _isSpammer($user, &$spamString)
	{
		//AVack:: 20101111 don't check admins
		//get usertype
		$fulluser = & JFactory::getUser();
		$user['usertype'] = $fulluser -> usertype;
		$fspamcheck = checkSpambots($this->params, $user['email'], $_SERVER['REMOTE_ADDR'], $user['username'], $user['usertype']);
		if ($fspamcheck == false || strlen($fspamcheck) == 0 || strpos($fspamcheck, "SPAMBOT_TRUE") === false)	
		{
			// not a spammer
			$spamString = "";
			return false;
		}
		
		// if we get here we have to deal with a spammer		
		$spamString = $fspamcheck;
		return true;
	}
	
	
	/**
	 * Send an e-mail about the failed login/register attempt to all admins.
	 *
	 * @param 	array		holds the user data
	 * @param 	string		hold the raw string returned by "check_spammers_plain.php"
	 * @param 	string		string added to the e-mail subject 
	 * 
	 * @return boolean True if user is a spammer and False if he isn't. 
	 */
	function _sendMailToAdmin(&$user, &$spamString, $subjectAddString)
	{	
		if (!$this->params->get('spbot_email_notifications', 1))	{
			// -> NO admin notifications
			return;
		}
		
		$name  = $user['fullname'];
		$username = $user['username'];
		$email = $user['email'];		
		$sPostersIP = $_SERVER['REMOTE_ADDR'];

		global $mainframe;
		$sitename 		= $mainframe->getCfg( 'sitename' );
		$mailfrom 		= $mainframe->getCfg( 'mailfrom' );
		$fromname 		= $mainframe->getCfg( 'fromname' );

		//get all super administrator
		$db		=& JFactory::getDBO();
		$query = 'SELECT name, email, sendEmail' .
				' FROM #__users' .
				' WHERE LOWER( usertype ) = "super administrator"';
		$db->setQuery( $query );
		$rows = $db->loadObjectList();

		// Send notification to all administrators
		$subject2 = sprintf ( JText::_( 'ACCOUNT DETAILS FOR_TXT' ), $name, $sitename) . $subjectAddString;
		$subject2 = html_entity_decode($subject2, ENT_QUOTES);

		// get superadministrators id
		foreach ( $rows as $row )
		{
			if ($row->sendEmail)
			{
				$message2 = sprintf ( JText::_( SEND_EMAIL_TO_ADMIN_TXT ), $row->name, $sitename, $name, $email, $username, $sPostersIP, $spamString);
				$message2 = html_entity_decode($message2, ENT_QUOTES);
				JUtility::sendMail($mailfrom, $fromname, $row->email, $subject2, $message2);
			}
		} 
	}	
}
